<?php
/**
 * upload_vip_gif.php
 * ==================
 * رفع صورة GIF للمستخدمين بالباقة الذهبية مع ضغط تلقائي
 * POST multipart: user_id + gif (file)
 */
header('Content-Type: application/json; charset=utf-8');
require 'db_connect.php';

$userId = isset($_POST['user_id']) ? (int)$_POST['user_id'] : 0;
if (!$userId) {
    http_response_code(400);
    exit(json_encode(['status' => 'error', 'message' => 'User ID مطلوب']));
}

try {
    // التحقق من الباقة الذهبية
    $stmt = $conn->prepare("SELECT vip_tier, vip_expires_at, vip_gif_url FROM users WHERE id = :id");
    $stmt->execute([':id' => $userId]);
    $user = $stmt->fetch();

    if (!$user) {
        exit(json_encode(['status' => 'error', 'message' => 'المستخدم غير موجود']));
    }
    if ($user['vip_tier'] !== 'gold') {
        exit(json_encode(['status' => 'error', 'message' => 'هذه الميزة للباقة الذهبية فقط']));
    }
    if ($user['vip_expires_at'] !== null && strtotime($user['vip_expires_at']) <= time()) {
        exit(json_encode(['status' => 'error', 'message' => 'انتهت صلاحية اشتراك VIP']));
    }

    // التحقق من وجود الملف
    if (!isset($_FILES['gif']) || $_FILES['gif']['error'] !== UPLOAD_ERR_OK) {
        $errCode = $_FILES['gif']['error'] ?? -1;
        exit(json_encode(['status' => 'error', 'message' => "فشل رفع الملف (code: {$errCode})"]));
    }

    $tmpPath  = $_FILES['gif']['tmp_name'];
    $fileSize = $_FILES['gif']['size'];

    // التحقق من الحجم (2MB)
    if ($fileSize > 2 * 1024 * 1024) {
        exit(json_encode(['status' => 'error', 'message' => 'الحجم يتجاوز 2MB']));
    }

    // التحقق من نوع الملف
    $finfo = finfo_open(FILEINFO_MIME_TYPE);
    $mime  = finfo_file($finfo, $tmpPath);
    finfo_close($finfo);

    if ($mime !== 'image/gif') {
        exit(json_encode(['status' => 'error', 'message' => 'يجب أن يكون الملف GIF فقط']));
    }

    // إنشاء مجلد الرفع إن لم يكن موجوداً
    $uploadDir = __DIR__ . '/vip_gifs/';
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0755, true);
    }

    // حذف GIF القديم إن وُجد
    if (!empty($user['vip_gif_url'])) {
        $oldFilename = basename(parse_url($user['vip_gif_url'], PHP_URL_PATH));
        $oldPath     = $uploadDir . $oldFilename;
        if (file_exists($oldPath)) {
            unlink($oldPath);
        }
    }

    // اسم الملف الجديد
    $filename   = 'vip_' . $userId . '_' . time() . '.gif';
    $uploadPath = $uploadDir . $filename;

    // ── ضغط GIF باستخدام ImageMagick إن كان متاحاً ──────────────────────
    $compressed = false;

    if (extension_loaded('imagick')) {
        try {
            $imagick = new Imagick($tmpPath);
            $imagick->resetIterator();
            $imagick = $imagick->coalesceImages();

            do {
                // تصغير إلى 320×320 إذا كان أكبر (مع الحفاظ على النسبة)
                $w = $imagick->getImageWidth();
                $h = $imagick->getImageHeight();
                if ($w > 320 || $h > 320) {
                    $imagick->thumbnailImage(320, 320, true, false);
                }
                // تقليل عدد الألوان لتخفيف الحجم
                $imagick->quantizeImage(128, Imagick::COLORSPACE_RGB, 0, false, false);
            } while ($imagick->nextImage());

            $imagick = $imagick->optimizeImageLayers();
            $imagick->setInterlaceScheme(Imagick::INTERLACE_GIF);
            $imagick->writeImages($uploadPath, true);
            $imagick->clear();
            $imagick->destroy();
            $compressed = true;

        } catch (Exception $e) {
            $compressed = false;
        }
    }

    // إذا ImageMagick غير متاح أو فشل — احفظ الملف كما هو
    if (!$compressed) {
        if (!move_uploaded_file($tmpPath, $uploadPath)) {
            exit(json_encode(['status' => 'error', 'message' => 'فشل حفظ الملف على السيرفر']));
        }
    }

    $gifUrl = "https://latrotech.online/Copel/vip_gifs/{$filename}";

    // تحديث قاعدة البيانات
    $updateStmt = $conn->prepare("UPDATE users SET vip_gif_url = :url WHERE id = :id");
    $updateStmt->execute([':url' => $gifUrl, ':id' => $userId]);

    echo json_encode([
        'status'      => 'success',
        'message'     => 'تم رفع الصورة بنجاح',
        'vip_gif_url' => $gifUrl,
        'compressed'  => $compressed
    ]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>