<?php
/**
 * upload_badge_icon.php
 * رفع أيقونات الشارات إلى /Copel/badges/
 */
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

$uploadDir = __DIR__ . '/';  // نفس مجلد السكريبت = /Copel/badges/
$baseUrl   = 'https://latrotech.online/Copel/badges/';

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || empty($_FILES['icon'])) {
    http_response_code(400);
    exit(json_encode(['status' => 'error', 'message' => 'لم يتم إرسال ملف']));
}

$file    = $_FILES['icon'];
$maxSize = 2 * 1024 * 1024; // 2MB
$allowed = ['image/png', 'image/jpeg', 'image/jpg', 'image/gif', 'image/webp'];

// تحقق من الحجم
if ($file['size'] > $maxSize) {
    exit(json_encode(['status' => 'error', 'message' => 'الحجم يتجاوز 2MB']));
}

// تحقق من النوع
$finfo = finfo_open(FILEINFO_MIME_TYPE);
$mime  = finfo_file($finfo, $file['tmp_name']);
finfo_close($finfo);

if (!in_array($mime, $allowed)) {
    exit(json_encode(['status' => 'error', 'message' => 'نوع الملف غير مدعوم (PNG/JPG/GIF/WEBP فقط)']));
}

// اسم فريد
$ext      = pathinfo($file['name'], PATHINFO_EXTENSION);
$filename = 'badge_' . uniqid() . '.' . strtolower($ext);
$destPath = $uploadDir . $filename;

if (!move_uploaded_file($file['tmp_name'], $destPath)) {
    http_response_code(500);
    exit(json_encode(['status' => 'error', 'message' => 'فشل في حفظ الملف']));
}

echo json_encode([
    'status'   => 'success',
    'filename' => $filename,
    'url'      => $baseUrl . $filename
]);
?>