<?php
/**
 * update_usage_time.php
 * ====================
 * تسجيل وقت استخدام التطبيق ومنح مكافآت الوقت
 * محدّث ليستخدم points_manager_v2.php
 *
 * @version 2.0
 * @date 2026-02-16
 */

header('Content-Type: application/json; charset=utf-8');
require 'db_connect.php';
require 'points_manager_v2.php'; // ← محدّث من points_manager.php

$data    = json_decode(file_get_contents('php://input'), true);
$user_id = $data['user_id'] ?? 0;
$seconds = $data['seconds']  ?? 0;

if (empty($user_id) || $seconds <= 0) {
    http_response_code(400);
    exit(json_encode([
        'status'  => 'error',
        'message' => 'بيانات غير صالحة. يجب توفير user_id و seconds.'
    ]));
}

try {
    $minutes = floor($seconds / 60);

    if ($minutes > 0) {
        $totalCoinsEarned = 0;
        $totalXpEarned    = 0;
        $leveledUp        = false;
        $newLevel         = 0;

        for ($i = 0; $i < $minutes; $i++) {
            // grantRewardV2 يتحقق من الحد اليومي (60 دقيقة) تلقائياً
            $result = grantRewardV2($conn, $user_id, 'spend_time_in_app');

            if ($result['status'] === 'success') {
                $totalCoinsEarned += $result['coins_earned'];
                $totalXpEarned    += $result['xp_earned'];

                if ($result['level_up']) {
                    $leveledUp = true;
                    $newLevel  = $result['new_level'];
                }
            }
            // إذا limit_reached: grantRewardV2 يسجل السجل تلقائياً بـ 0 coins
        }

        echo json_encode([
            'status' => 'success',
            'data'   => [
                'minutes_logged'      => $minutes,
                'total_coins_earned'  => $totalCoinsEarned,
                'total_xp_earned'     => $totalXpEarned,
                'level_up'            => $leveledUp,
                'new_level'           => $newLevel
            ]
        ]);

    } else {
        echo json_encode([
            'status' => 'info',
            'data'   => [
                'seconds_logged' => $seconds,
                'minutes_logged' => 0
            ]
        ]);
    }

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'status'  => 'error',
        'message' => 'خطأ في الخادم: ' . $e->getMessage()
    ]);
}
?>