<?php
// update_profile.php
// v2 - يرجع بيانات المستخدم المحدثة بالكامل

header('Content-Type: application/json; charset=utf-8');
require 'db_connect.php';

// --- 1. استقبال البيانات من التطبيق ---
$data = json_decode(file_get_contents('php://input'), true);

$userId = $data['user_id'] ?? 0;
$displayName = trim($data['display_name'] ?? '');
$username = trim($data['username'] ?? '');
$email = trim($data['email'] ?? '');

if (empty($userId)) {
    http_response_code(400 );
    exit(json_encode(['status' => 'error', 'message' => 'User ID is required.']));
}

try {
    // --- 2. جلب البيانات الحالية للمستخدم للمقارنة ---
    $stmt_current = $conn->prepare("SELECT display_name, username, email, auth_type FROM users WHERE id = :id");
    $stmt_current->execute([':id' => $userId]);
    $currentUser = $stmt_current->fetch(PDO::FETCH_ASSOC);

    if (!$currentUser) {
        http_response_code(404 );
        exit(json_encode(['status' => 'error', 'message' => 'User not found.']));
    }

    $updates = [];
    $params = [':user_id' => $userId];

    // --- 3. التحقق من كل حقل وتحديد ما إذا كان قد تغير ---

    // التحقق من Display Name
    if (!empty($displayName) && $displayName !== $currentUser['display_name']) {
        if (mb_strlen($displayName) < 3) {
            throw new Exception("يجب أن يتكون الاسم من 3 أحرف على الأقل.");
        }
        $updates[] = "display_name = :display_name";
        $params[':display_name'] = $displayName;
    }

    // التحقق من Username
    if (!empty($username) && $username !== $currentUser['username']) {
        if (strlen($username) < 3 || !preg_match('/^[a-zA-Z0-9_]+$/', $username)) {
            throw new Exception("يجب أن يتكون اسم المستخدم من 3 أحرف على الأقل ويحتوي فقط على حروف إنجليزية وأرقام وشرطة سفلية (_).");
        }
        $stmt_check = $conn->prepare("SELECT id FROM users WHERE username = :username AND id != :user_id");
        $stmt_check->execute([':username' => $username, ':user_id' => $userId]);
        if ($stmt_check->fetch()) {
            throw new Exception("اسم المستخدم هذا مستخدم بالفعل.");
        }
        $updates[] = "username = :username";
        $params[':username'] = $username;
    }

    // التحقق من Email (فقط إذا لم يكن المستخدم من جوجل)
    if ($currentUser['auth_type'] !== 'google' && !empty($email) && $email !== $currentUser['email']) {
        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            throw new Exception("الرجاء إدخال بريد إلكتروني صالح.");
        }
        $stmt_check = $conn->prepare("SELECT id FROM users WHERE email = :email AND id != :user_id");
        $stmt_check->execute([':email' => $email, ':user_id' => $userId]);
        if ($stmt_check->fetch()) {
            throw new Exception("هذا البريد الإلكتروني مسجل بالفعل.");
        }
        $updates[] = "email = :email";
        $params[':email'] = $email;
    }

    // --- 4. تنفيذ التحديث إذا كانت هناك تغييرات ---
    if (!empty($updates)) {
        $sql = "UPDATE users SET " . implode(', ', $updates) . " WHERE id = :user_id";
        $stmt_update = $conn->prepare($sql);
        if (!$stmt_update->execute($params)) {
            throw new Exception("فشل تحديث البيانات في قاعدة البيانات.");
        }
    }

    // ★★★★★   هذا هو الجزء الذي يحل المشكلة   ★★★★★
    // 5. جلب كل بيانات المستخدم المحدثة لإرجاعها
    $stmt_get_updated = $conn->prepare("SELECT id, display_name, username, email, invitation_code, profile_image_url, auth_type FROM users WHERE id = :id");
    $stmt_get_updated->execute([':id' => $userId]);
    $updatedUser = $stmt_get_updated->fetch(PDO::FETCH_ASSOC);

    // 6. إرسال الرد مع كائن updated_data
    echo json_encode([
        'status' => 'success',
        'message' => 'تم تحديث معلوماتك بنجاح.',
        'updated_data' => $updatedUser // <-- هذا هو الجزء المهم
    ]);
    // ★★★★★   نهاية الجزء الذي يحل المشكلة   ★★★★★

} catch (Exception $e) {
    $errorCode = ($e->getMessage() === "اسم المستخدم هذا مستخدم بالفعل." || $e->getMessage() === "هذا البريد الإلكتروني مسجل بالفعل.") ? 409 : 400;
    http_response_code($errorCode );
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>
