<?php
// update_personal_info.php
// يحدّث المقولة الشخصية والعمر والحالة الاجتماعية للمستخدم

header('Content-Type: application/json; charset=utf-8');
require 'db_connect.php';

$data = json_decode(file_get_contents('php://input'), true);

$userId       = $data['user_id']       ?? 0;
$bio          = isset($data['bio'])          ? trim($data['bio'])          : null;
$age          = isset($data['age'])          ? (int) $data['age']          : null;
$maritalStatus = isset($data['marital_status']) ? trim($data['marital_status']) : null;

if (empty($userId)) {
    http_response_code(400);
    exit(json_encode(['status' => 'error', 'message' => 'User ID is required.']));
}

$allowedStatuses = ['single', 'in_relationship', 'engaged', 'married'];

try {
    // التحقق من وجود المستخدم
    $stmt_check = $conn->prepare("SELECT id FROM users WHERE id = :id");
    $stmt_check->execute([':id' => $userId]);
    if (!$stmt_check->fetch()) {
        http_response_code(404);
        exit(json_encode(['status' => 'error', 'message' => 'User not found.']));
    }

    $updates = [];
    $params  = [':user_id' => $userId];

    // المقولة الشخصية
    if ($bio !== null) {
        if (mb_strlen($bio) > 200) {
            throw new Exception("يجب ألا تتجاوز المقولة 200 حرف.");
        }
        $updates[] = "bio = :bio";
        $params[':bio'] = $bio;
    }

    // العمر
    if ($age !== null) {
        if ($age < 13 || $age > 100) {
            throw new Exception("يجب أن يكون العمر بين 13 و100.");
        }
        $updates[] = "age = :age";
        $params[':age'] = $age;
    }

    // الحالة الاجتماعية
    if ($maritalStatus !== null) {
        if (!in_array($maritalStatus, $allowedStatuses)) {
            throw new Exception("الحالة الاجتماعية غير صالحة.");
        }
        $updates[] = "marital_status = :marital_status";
        $params[':marital_status'] = $maritalStatus;
    }

    if (!empty($updates)) {
        $sql = "UPDATE users SET " . implode(', ', $updates) . " WHERE id = :user_id";
        $stmt_update = $conn->prepare($sql);
        if (!$stmt_update->execute($params)) {
            throw new Exception("فشل تحديث البيانات في قاعدة البيانات.");
        }
    }

    // جلب البيانات المحدّثة
    $stmt_get = $conn->prepare("SELECT id, bio, age, marital_status FROM users WHERE id = :id");
    $stmt_get->execute([':id' => $userId]);
    $updatedUser = $stmt_get->fetch(PDO::FETCH_ASSOC);

    echo json_encode([
        'status'       => 'success',
        'message'      => 'تم تحديث معلوماتك الشخصية بنجاح.',
        'updated_data' => $updatedUser
    ]);

} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>