<?php
// update_milestones.php
// Updates the milestone dates for a couple.

header('Content-Type: application/json; charset=utf-8');
require 'db_connect.php';

$data = json_decode(file_get_contents('php://input'), true);
$user_id = $data['user_id'] ?? 0;

// استلام التواريخ (قد يكون بعضها فارغاً)
$first_message = !empty($data['first_message_date']) ? $data['first_message_date'] : null;
$first_meeting = !empty($data['first_meeting_date']) ? $data['first_meeting_date'] : null;
$first_date = !empty($data['first_date_date']) ? $data['first_date_date'] : null;
$relationship_start = !empty($data['relationship_start_date']) ? $data['relationship_start_date'] : null;

if (empty($user_id)) {
    http_response_code(400 );
    exit(json_encode(['status' => 'error', 'message' => 'User ID is required.']));
}

try {
    // 1. جلب couple_id للمستخدم
    $stmt_couple = $conn->prepare("SELECT couple_id FROM users WHERE id = :user_id");
    $stmt_couple->execute([':user_id' => $user_id]);
    $user_data = $stmt_couple->fetch(PDO::FETCH_ASSOC);

    if (!$user_data || empty($user_data['couple_id'])) {
        throw new Exception("User is not part of a couple.");
    }
    $couple_id = $user_data['couple_id'];

    // 2. تحديث الأعمدة في جدول couples
    $stmt_update = $conn->prepare(
        "UPDATE couples SET 
            first_message_date = :fmd,
            first_meeting_date = :fmmd,
            first_date_date = :fdd,
            relationship_start_date = :rsd
         WHERE id = :couple_id"
    );

    $stmt_update->execute([
        ':fmd' => $first_message,
        ':fmmd' => $first_meeting,
        ':fdd' => $first_date,
        ':rsd' => $relationship_start,
        ':couple_id' => $couple_id
    ]);

    echo json_encode([
        'status' => 'success',
        'message' => 'تم تحديث اللحظات المميزة بنجاح!'
    ]);

} catch (Exception $e) {
    http_response_code(500 );
    error_log('Update Milestones Error: ' . $e->getMessage());
    echo json_encode(['status' => 'error', 'message' => 'Server error while updating milestones.']);
}
?>
