<?php
// update_message_status.php (v2 - More Robust)

header('Content-Type: application/json; charset=utf-8');

require_once __DIR__ . '/PusherHelper.php'; 
require 'db_connect.php'; 

ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', 'php-errors.log');
error_reporting(E_ALL);

$data = json_decode(file_get_contents('php://input'), true);

$userId = isset($data['user_id']) ? (int)$data['user_id'] : 0;
$partnerId = isset($data['partner_id']) ? (int)$data['partner_id'] : 0;
$newStatus = isset($data['status']) ? $data['status'] : '';

if ($userId <= 0 || $partnerId <= 0 || !in_array($newStatus, ['delivered', 'read'])) {
    http_response_code(400 );
    // لا نرسل رسالة خطأ لأن هذا الطلب يعمل في الخلفية
    exit();
}

try {
    // 1. تحديث حالة جميع الرسائل غير المقروءة من الشريك إلى المستخدم الحالي
    // نحن نحدث فقط الرسائل التي حالتها أقل من الحالة الجديدة
    // (مثال: إذا كانت الحالة الجديدة 'read'، فسيتم تحديث 'sent' و 'delivered')
    $sql = "UPDATE messages SET status = :newStatus 
            WHERE recipient_id = :userId 
            AND sender_id = :partnerId 
            AND status != 'read'"; // لا نحدث الرسائل المقروءة بالفعل

    // إذا كانت الحالة الجديدة 'delivered'، لا تقم بتحديث الرسائل التي هي 'read'
    if ($newStatus === 'delivered') {
        $sql .= " AND status = 'sent'";
    }
    
    $stmt = $conn->prepare($sql);
    $stmt->execute([
        'newStatus' => $newStatus,
        'userId' => $userId,
        'partnerId' => $partnerId
    ]);

    // 2. إرسال حدث Pusher إلى الشريك (المرسل الأصلي) لإعلامه بالتحديث
    $pusher_data = [
        'status' => $newStatus,
        'updated_by' => $userId // نخبر الطرف الآخر من الذي قام بالتحديث
    ];
    
    // القناة هي نفسها قناة المحادثة
    $channel_name = 'chat-' . min($userId, $partnerId) . '-' . max($userId, $partnerId);
    
    send_pusher_trigger(
        "c0a2fe3c47f0775d0be1", 
        "85330156aec9dd641145", 
        "2109257", 
        "mt1", 
        $channel_name, 
        'message-status-update', // اسم الحدث الذي يستمع إليه التطبيق
        $pusher_data
    );

    // لا حاجة لإرسال رد ناجح، الطلب يعمل في الخلفية
    http_response_code(204 ); // 204 No Content

} catch (Exception $e) {
    error_log("Update message status failed: " . $e->getMessage());
    // لا نرسل رد خطأ لأن هذا الطلب يعمل في الخلفية
    http_response_code(500 );
}

$conn = null;
?>
