<?php
// update_location.php (النسخة النهائية والصحيحة)

header('Content-Type: application/json');
require 'db_connect.php';

// لا حاجة لعرض الأخطاء في النسخة النهائية
ini_set('display_errors', 0);
error_reporting(0);

// 1. تحقق من أن الطلب هو POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405 ); // Method Not Allowed
    echo json_encode(['status' => 'error', 'message' => 'Only POST method is allowed.']);
    exit();
}

// 2. اقرأ البيانات وتحقق منها
$data = json_decode(file_get_contents('php://input'), true);

if (json_last_error() !== JSON_ERROR_NONE) {
    http_response_code(400 );
    echo json_encode(['status' => 'error', 'message' => 'Invalid JSON format.']);
    exit();
}

$user_id = $data['user_id'] ?? 0;
$latitude = isset($data['latitude']) ? (float)$data['latitude'] : null;
$longitude = isset($data['longitude']) ? (float)$data['longitude'] : null;

if (empty($user_id) || $latitude === null || $longitude === null) {
    http_response_code(400 ); // Bad Request
    echo json_encode(['status' => 'error', 'message' => 'user_id, latitude, and longitude are required.']);
    exit();
}

// 3. قم بتنفيذ العملية داخل try-catch
try {
    // --- ★★★★★   التعديل الرئيسي هنا   ★★★★★ ---
    // تم إزالة الحقل غير الموجود `last_location_update`
    $stmt = $conn->prepare("UPDATE users SET latitude = :lat, longitude = :lon WHERE id = :id");
    // --- ★★★★★    نهاية التعديل الرئيسي    ★★★★★ ---
    
    $stmt->execute([
        ':lat' => $latitude,
        ':lon' => $longitude,
        ':id' => $user_id
    ]);

    // طالما لم يحدث خطأ، فالعملية ناجحة
    echo json_encode(['status' => 'success', 'message' => 'Location updated successfully.']);

} catch (PDOException $e) {
    // في حالة حدوث خطأ في قاعدة البيانات
    http_response_code(500 ); // Internal Server Error
    // سجل الخطأ في الخادم (إذا كانت الصلاحيات تسمح)
    error_log('Location Update Failed: ' . $e->getMessage());
    echo json_encode(['status' => 'error', 'message' => 'A server error occurred.']);
}
?>
