<?php
// update_fcm_token.php

header('Content-Type: application/json');
require 'db_connect.php'; // استخدام ملف الاتصال الموحد

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Only POST method is allowed']);
    exit();
}

$data = json_decode(file_get_contents('php://input'), true);
$user_id = $data['user_id'] ?? 0;
$fcm_token = $data['fcm_token'] ?? '';

if (empty($user_id) || empty($fcm_token)) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'user_id and fcm_token are required']);
    exit();
}

try {
    $stmt = $conn->prepare("UPDATE users SET fcm_token = :fcm_token WHERE id = :user_id");
    $stmt->execute([':fcm_token' => $fcm_token, ':user_id' => $user_id]);

    if ($stmt->rowCount() > 0) {
        echo json_encode(['status' => 'success', 'message' => 'FCM token updated successfully']);
    } else {
        // هذا ليس خطأ بالضرورة، قد يكون الرمز هو نفسه لم يتغير
        echo json_encode(['status' => 'success', 'message' => 'FCM token is already up to date.']);
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Failed to update FCM token: ' . $e->getMessage()]);
}
?>
