<?php
// update_activity.php
// هذا الملف مسؤول عن تسجيل بداية ونهاية جلسات استخدام التطبيق

header('Content-Type: application/json');
require 'db_connect.php';

// التأكد من أن الطلب من نوع POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['status' => 'error', 'message' => 'Only POST method is allowed']);
    exit();
}

$data = json_decode(file_get_contents('php://input'), true);
$user_id = $data['user_id'] ?? null;
$event_type = $data['event'] ?? null; // 'session_start' أو 'session_end'
$session_id = $data['session_id'] ?? null; // سيتم إرساله من التطبيق عند إنهاء الجلسة

if (empty($user_id) || empty($event_type)) {
    http_response_code(400); // Bad Request
    echo json_encode(['status' => 'error', 'message' => 'user_id and event are required']);
    exit();
}

try {
    if ($event_type === 'session_start') {
        // عند بدء جلسة جديدة، قم بإدراج سجل جديد في جدول user_activity
        $stmt = $conn->prepare("INSERT INTO user_activity (user_id, session_start) VALUES (:user_id, NOW())");
        $stmt->execute([':user_id' => $user_id]);
        
        // جلب الـ ID الخاص بالجلسة الجديدة لإرجاعه إلى التطبيق
        $new_session_id = $conn->lastInsertId();
        
        echo json_encode([
            'status' => 'success',
            'message' => 'Session started successfully.',
            'session_id' => $new_session_id // التطبيق سيحفظ هذا الـ ID
        ]);

    } elseif ($event_type === 'session_end') {
        // عند إنهاء الجلسة، قم بتحديث السجل الموجود
        if (empty($session_id)) {
            throw new Exception('session_id is required for session_end event', 400);
        }

        // 1. جلب وقت بدء الجلسة
        $stmt_start = $conn->prepare("SELECT session_start FROM user_activity WHERE id = :session_id AND user_id = :user_id");
        $stmt_start->execute([':session_id' => $session_id, ':user_id' => $user_id]);
        $session = $stmt_start->fetch();

        if (!$session) {
            throw new Exception('Session not found or does not belong to the user.', 404);
        }

        // 2. حساب مدة الجلسة بالثواني
        $start_time = new DateTime($session['session_start']);
        $end_time = new DateTime(); // الوقت الحالي
        $duration = $end_time->getTimestamp() - $start_time->getTimestamp();

        // 3. تحديث سجل الجلسة بوقت النهاية والمدة
        $stmt_update = $conn->prepare(
            "UPDATE user_activity 
             SET session_end = NOW(), duration_seconds = :duration 
             WHERE id = :session_id"
        );
        $stmt_update->execute([':duration' => $duration, ':session_id' => $session_id]);

        echo json_encode([
            'status' => 'success',
            'message' => 'Session ended successfully.',
            'duration_seconds' => $duration
        ]);

    } else {
        throw new Exception('Invalid event type.', 400);
    }

} catch (Exception $e) {
    $code = in_array($e->getCode(), [400, 404]) ? $e->getCode() : 500;
    http_response_code($code);
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>
