<?php
// unlink_partner.php (v3 - يدعم التحديث اللحظي عبر Pusher)

header('Content-Type: application/json; charset=utf-8');

// استدعاء ملف المساعدة الذي يحتوي على دالة إرسال طلبات Pusher
require_once __DIR__ . '/PusherHelper.php'; 

require 'db_connect.php';

// إعدادات تسجيل الأخطاء
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', 'php-errors.log');
error_reporting(E_ALL);

try {
    if (!isset($conn)) {
        throw new Exception("فشل الاتصال بقاعدة البيانات.");
    }

    // 1. استقبال البيانات من التطبيق
    $data = json_decode(file_get_contents('php://input'), true);
    $user_id = $data['user_id'] ?? null;

    if (empty($user_id)) {
        throw new Exception("معرّف المستخدم مطلوب.", 400);
    }

    // --- بداية العملية (Transaction) ---
    if ($conn instanceof PDO) {
        $conn->beginTransaction();
    }

    // 2. جلب couple_id الخاص بالمستخدم
    $stmt_get_user = $conn->prepare("SELECT couple_id FROM users WHERE id = :id");
    $stmt_get_user->execute([':id' => $user_id]);
    $user = $stmt_get_user->fetch(PDO::FETCH_ASSOC);

    $couple_id = $user['couple_id'] ?? null;

    if (empty($couple_id)) {
        if ($conn instanceof PDO && $conn->inTransaction()) {
            $conn->rollBack();
        }
        echo json_encode(['status' => 'success', 'message' => 'أنت لست مرتبطاً بالفعل.']);
        exit();
    }

    // 3. جلب معرف وتوكن الشريك الآخر (قبل الحذف)
    $stmt_get_partner = $conn->prepare(
        "SELECT u.id, u.fcm_token 
         FROM couples c
         JOIN users u ON (c.user1_id = u.id OR c.user2_id = u.id)
         WHERE c.id = :cid AND u.id != :current_user_id"
    );
    $stmt_get_partner->execute([':cid' => $couple_id, ':current_user_id' => $user_id]);
    $partner = $stmt_get_partner->fetch(PDO::FETCH_ASSOC);
    
    $partnerId = $partner['id'] ?? null;
    $partnerToken = $partner['fcm_token'] ?? null;

    // 4. تحديث جدول users لكلا الشريكين بجعل couple_id = NULL
    $stmt_update_users = $conn->prepare("UPDATE users SET couple_id = NULL WHERE couple_id = :cid");
    $stmt_update_users->execute([':cid' => $couple_id]);

    // 5. حذف سجل الارتباط من جدول couples
    $stmt_delete_couple = $conn->prepare("DELETE FROM couples WHERE id = :cid");
    $stmt_delete_couple->execute([':cid' => $couple_id]);

    // 6. (اختياري) حذف أي طلبات ارتباط معلقة بين هذين المستخدمين
    if ($partnerId) {
        $stmt_cleanup_requests = $conn->prepare(
            "DELETE FROM connection_requests 
             WHERE (requester_id = :user1 AND recipient_id = :user2) 
                OR (requester_id = :user2 AND recipient_id = :user1)"
        );
        $stmt_cleanup_requests->execute([':user1' => $user_id, ':user2' => $partnerId]);
    }

    // ★★★★★   بداية منطقة Pusher   ★★★★★
    // 7. إرسال تحديث لحظي لكلا المستخدمين لتحديث واجهتهما
    if ($partnerId) {
        $pusher_data = ['status' => 'unlinked'];
        $event_name = 'status-update';

        // إرسال للمستخدم الأول (الذي بدأ الانفصال)
        $user1_channel = 'user-' . $user_id;
        send_pusher_trigger("c0a2fe3c47f0775d0be1", "85330156aec9dd641145", "2109257", "mt1", $user1_channel, $event_name, $pusher_data);

        // إرسال للمستخدم الثاني (الشريك السابق)
        $user2_channel = 'user-' . $partnerId;
        send_pusher_trigger("c0a2fe3c47f0775d0be1", "85330156aec9dd641145", "2109257", "mt1", $user2_channel, $event_name, $pusher_data);
    }
    // ★★★★★    نهاية منطقة Pusher    ★★★★★

    // --- تأكيد العملية (Commit) ---
    if ($conn instanceof PDO) {
        $conn->commit();
    }

    // 8. إرسال رد ناجح مع توكن الشريك (لإشعار FCM الخارجي)
    echo json_encode([
        'status' => 'success',
        'message' => 'تم فك الارتباط بنجاح.',
        'data' => [
            'partner_token' => $partnerToken
        ]
    ]);

} catch (Throwable $e) {
    if (isset($conn) && $conn instanceof PDO && $conn->inTransaction()) {
        $conn->rollBack();
    }
    http_response_code(500 );
    error_log("Unlink failed: " . $e->getMessage());
    echo json_encode(['status' => 'error', 'message' => 'حدث خطأ غير متوقع: ' . $e->getMessage()]);
}

$conn = null;
exit();
?>
