<?php
// unblock_user.php

header('Content-Type: application/json; charset=utf-8');
require 'db_connect.php';

$data = json_decode(file_get_contents('php://input'), true);

$blockerId = $data['blocker_id'] ?? 0;
$blockedId = $data['blocked_id'] ?? 0;

if (empty($blockerId) || empty($blockedId)) {
    http_response_code(400 );
    exit(json_encode(['status' => 'error', 'message' => 'معرفات المستخدمين مطلوبة لإلغاء الحظر.']));
}

try {
    $stmt = $conn->prepare(
        "DELETE FROM blocked_users 
         WHERE blocker_id = :blocker_id AND blocked_id = :blocked_id"
    );

    $stmt->execute([
        ':blocker_id' => $blockerId,
        ':blocked_id' => $blockedId
    ]);

    // التحقق مما إذا كان قد تم حذف أي صف
    if ($stmt->rowCount() > 0) {
        echo json_encode([
            'status' => 'success',
            'message' => 'تم إلغاء حظر المستخدم بنجاح.'
        ]);
    } else {
        // هذا يعني أن المستخدم لم يكن محظوراً في المقام الأول
        echo json_encode([
            'status' => 'success', // لا يعتبر خطأ، بل عملية تمت بنجاح
            'message' => 'المستخدم لم يكن محظوراً.'
        ]);
    }

} catch (Exception $e) {
    http_response_code(500 );
    error_log("Unblock User Error: " . $e->getMessage());
    echo json_encode(['status' => 'error', 'message' => 'حدث خطأ في الخادم أثناء محاولة إلغاء الحظر.']);
}
?>
