<?php
// typing_event.php
// يستقبل حالة الكتابة من العميل ويرسلها إلى Pusher

header('Content-Type: application/json; charset=utf-8');

// استدعاء ملف المساعدة الخاص بـ Pusher
require_once __DIR__ . '/PusherHelper.php'; 

// لا نحتاج للاتصال بقاعدة البيانات هنا

$data = json_decode(file_get_contents('php://input'), true);

// استقبال البيانات والتحقق منها
$senderId = $data['sender_id'] ?? 0;
$recipientId = $data['recipient_id'] ?? 0;
$eventType = $data['event_type'] ?? ''; // 'client-typing-started' or 'client-typing-stopped'
$socketId = $data['socket_id'] ?? null; // مهم جداً

if ($senderId <= 0 || $recipientId <= 0 || empty($eventType) || empty($socketId)) {
    http_response_code(400 );
    echo json_encode(['status' => 'error', 'message' => 'بيانات غير مكتملة.']);
    exit();
}

try {
    // تحديد اسم القناة
    $channel_name = 'chat-' . min($senderId, $recipientId) . '-' . max($senderId, $recipientId);
    
    // إرسال الحدث باستخدام الدالة المساعدة، مع تمرير socket_id
    send_pusher_trigger(
        "c0a2fe3c47f0775d0be1", // key
        "85330156aec9dd641145", // secret
        "2109257",              // app_id
        "mt1",                  // cluster
        $channel_name,          // اسم القناة
        $eventType,             // اسم الحدث (client-typing-started/stopped)
        [],                     // لا نحتاج لإرسال بيانات مع هذا الحدث
        $socketId               // **هذا هو الجزء الأهم**
    );

    echo json_encode(['status' => 'success']);

} catch (Exception $e) {
    http_response_code(500 );
    error_log("Typing event failed: " . $e->getMessage());
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>
