<?php
// trigger_notification.php (ملف مخصص لإرسال الإشعارات فقط)

require 'db_connect.php';
require 'vendor/autoload.php'; // <-- تأكد من أن هذا المسار صحيح
header('Content-Type: application/json');

// --- دالة إرسال الإشعار (موجودة هنا لضمان عمل الملف بشكل مستقل) ---
function sendFcmNotification($recipientToken, $title, $body, $data) {
    $credentialsFilePath = __DIR__ . '/google-credentials.json';
    $projectId = 'couple-d1a57'; // تأكد من أن هذا هو ID مشروعك

    try {
        $client = new Google\Client();
        $client->setAuthConfig($credentialsFilePath);
        $client->addScope('https://www.googleapis.com/auth/firebase.messaging');
        $accessToken = $client->fetchAccessTokenWithAssertion()['access_token'];

        $url = "https://fcm.googleapis.com/v1/projects/{$projectId}/messages:send";
        
        $message = [
            'message' => [
                'token' => $recipientToken,
                'notification' => ['title' => $title, 'body' => $body],
                'data' => $data,
                'android' => [
                    'priority' => 'high',
                    'notification' => ['sound' => 'default', 'channel_id' => 'couple_app_channel']
                ],
                'apns' => ['payload' => ['aps' => ['sound' => 'default']]]
            ]
        ];

        $headers = ['Authorization: Bearer ' . $accessToken, 'Content-Type: application/json'];
        $ch = curl_init();
        // ... (باقي كود cURL)
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($message));
        $response = curl_exec($ch);
        curl_close($ch);
        return $response; // إرجاع الرد للتحقق
    } catch (Exception $e) {
        return null;
    }
}

// --- منطق الـ API الرئيسي ---
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Only POST method is allowed']);
    exit();
}

$data = json_decode(file_get_contents('php://input'), true);
$sender_id = $data['sender_id'] ?? null;

if (empty($sender_id)) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'sender_id is required']);
    exit();
}

try {
    // جلب معلومات المرسل والشريك
    $stmt_info = $conn->prepare(
        "SELECT u1.username as sender_username, u2.fcm_token as partner_fcm_token
         FROM users u1
         JOIN users u2 ON u1.couple_id = u2.couple_id AND u1.id != u2.id
         WHERE u1.id = :sender_id"
    );
    $stmt_info->execute([':sender_id' => $sender_id]);
    $info = $stmt_info->fetch();

    if (!$info || empty($info['partner_fcm_token'])) {
        throw new Exception('Partner token not found or user not linked.', 404);
    }

    // إرسال الإشعار
    $sender_username = $info['sender_username'];
    $notification_title = "❤️ رسالة من شريكك";
    $notification_body = "$sender_username أرسل لك إشارة حب!";
    $notification_data = ['action' => 'LOVE_SIGNAL'];
    
    $fcm_response = sendFcmNotification($info['partner_fcm_token'], $notification_title, $notification_body, $notification_data);

    echo json_encode(['status' => 'success', 'message' => 'Notification triggered.', 'fcm_response' => json_decode($fcm_response)]);

} catch (Exception $e) {
    $code = $e->getCode() == 404 ? 404 : 500;
    http_response_code($code);
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>
