<?php
// track_user.php - النسخة المحدّثة مع نظام حظر الأجهزة
// ================================================

error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);

header('Content-Type: application/json; charset=utf-8');

try {
    $conn = new mysqli("localhost", "u323701002_us_coc", "AS_05344465928pr", "u323701002_coc");
    
    if ($conn->connect_error) {
        throw new Exception('Database connection failed: ' . $conn->connect_error);
    }
    
    $conn->set_charset("utf8mb4");

    $raw_input = file_get_contents('php://input');
    $input     = json_decode($raw_input, true);
    
    if (!$input) {
        throw new Exception('No input data');
    }
    
    $action    = isset($input['action'])    ? $input['action']    : null;
    $device_id = isset($input['device_id']) ? $input['device_id'] : null;
    
    if (!$action || !$device_id) {
        throw new Exception('Missing action or device_id');
    }

    // ★★★ فحص حظر الجهاز (يُطبَّق على جميع الطلبات) ★★★
    $ban_check = $conn->query("SHOW TABLES LIKE 'banned_devices'");
    if ($ban_check->num_rows > 0) {
        $stmt = $conn->prepare("
            SELECT id, reason, is_permanent, ban_expires
            FROM banned_devices
            WHERE device_id = ?
              AND is_active  = 1
              AND (is_permanent = 1 OR ban_expires IS NULL OR ban_expires > NOW())
            LIMIT 1
        ");
        $stmt->bind_param("s", $device_id);
        $stmt->execute();
        $ban = $stmt->get_result()->fetch_assoc();
        $stmt->close();

        if ($ban) {
            // الجهاز محظور - أرسل رد الحظر للتطبيق
            echo json_encode([
                'status'    => 'banned',
                'is_banned' => true,
                'reason'    => $ban['reason'] ?? 'مخالفة قواعد الاستخدام',
                'permanent' => (bool)$ban['is_permanent'],
                'expires'   => $ban['ban_expires'],
                'message'   => 'تم حظر هذا الجهاز من استخدام التطبيق.'
            ]);
            $conn->close();
            exit;
        }
    }
    // ★★★ نهاية فحص الحظر ★★★

    // -----------------------------------------------
    // معالجة install
    // -----------------------------------------------
    if ($action === 'install') {
        $app_version     = isset($input['app_version'])     ? $input['app_version']     : 'unknown';
        $android_version = isset($input['android_version']) ? $input['android_version'] : 'unknown';
        $device_model    = isset($input['device_model'])    ? $input['device_model']    : 'unknown';
        
        $stmt = $conn->prepare("
            INSERT INTO user_devices (device_id, app_version, android_version, device_model, first_install_date, last_update) 
            VALUES (?, ?, ?, ?, NOW(), NOW())
            ON DUPLICATE KEY UPDATE 
                app_version     = VALUES(app_version),
                android_version = VALUES(android_version),
                device_model    = VALUES(device_model),
                last_update     = NOW()
        ");
        $stmt->bind_param("ssss", $device_id, $app_version, $android_version, $device_model);
        $stmt->execute();
        $stmt->close();
        
        echo json_encode(['status' => 'success', 'message' => 'Install tracked']);
    }

    // -----------------------------------------------
    // معالجة open
    // -----------------------------------------------
    elseif ($action === 'open') {
        $user_id         = isset($input['user_id'])         ? intval($input['user_id'])         : 0;
        $app_version     = isset($input['app_version'])     ? $input['app_version']             : 'unknown';
        $android_version = isset($input['android_version']) ? $input['android_version']         : 'unknown';
        $device_model    = isset($input['device_model'])    ? $input['device_model']            : 'unknown';
        
        if ($user_id > 0) {
            // تحديث user_devices
            $stmt = $conn->prepare("
                INSERT INTO user_devices (device_id, user_id, app_version, android_version, device_model, first_install_date, last_app_open, total_opens, last_update) 
                VALUES (?, ?, ?, ?, ?, NOW(), NOW(), 1, NOW())
                ON DUPLICATE KEY UPDATE 
                    user_id         = VALUES(user_id),
                    app_version     = VALUES(app_version),
                    android_version = VALUES(android_version),
                    device_model    = VALUES(device_model),
                    last_app_open   = NOW(),
                    total_opens     = total_opens + 1,
                    last_update     = NOW()
            ");
            $stmt->bind_param("sisss", $device_id, $user_id, $app_version, $android_version, $device_model);
            $stmt->execute();
            $stmt->close();
            
            // تحديث users
            $stmt = $conn->prepare("UPDATE users SET is_active = 1, last_active = NOW(), app_open_count = COALESCE(app_open_count, 0) + 1 WHERE id = ?");
            $stmt->bind_param("i", $user_id);
            $stmt->execute();
            $stmt->close();
            
            // إنشاء جلسة جديدة في user_activity_sessions
            $stmt = $conn->prepare("INSERT INTO user_activity_sessions (user_id, device_id, session_start, last_heartbeat) VALUES (?, ?, NOW(), NOW())");
            $stmt->bind_param("is", $user_id, $device_id);
            $stmt->execute();
            $stmt->close();
        }
        
        echo json_encode(['status' => 'success', 'message' => 'Open tracked']);
    }

    // -----------------------------------------------
    // معالجة close
    // -----------------------------------------------
    elseif ($action === 'close') {
        $user_id = isset($input['user_id']) ? intval($input['user_id']) : 0;
        
        if ($user_id > 0) {
            // تحديث users
            $stmt = $conn->prepare("UPDATE users SET is_active = 0, last_active = NOW() WHERE id = ?");
            $stmt->bind_param("i", $user_id);
            $stmt->execute();
            $stmt->close();
            
            // إغلاق الجلسة
            $stmt = $conn->prepare("
                UPDATE user_activity_sessions 
                SET session_end       = NOW(),
                    duration_seconds  = TIMESTAMPDIFF(SECOND, session_start, NOW())
                WHERE user_id    = ?
                  AND device_id  = ?
                  AND session_end IS NULL 
                ORDER BY session_start DESC 
                LIMIT 1
            ");
            $stmt->bind_param("is", $user_id, $device_id);
            $stmt->execute();
            $stmt->close();
        }
        
        echo json_encode(['status' => 'success', 'message' => 'Close tracked']);
    }

    // -----------------------------------------------
    // معالجة heartbeat
    // -----------------------------------------------
    elseif ($action === 'heartbeat') {
        $user_id = isset($input['user_id']) ? intval($input['user_id']) : 0;
        
        if ($user_id > 0) {
            // تحديث users
            $stmt = $conn->prepare("UPDATE users SET is_active = 1, last_active = NOW() WHERE id = ?");
            $stmt->bind_param("i", $user_id);
            $stmt->execute();
            $stmt->close();
            
            // تحديث heartbeat في الجلسة الحالية
            $stmt = $conn->prepare("
                UPDATE user_activity_sessions 
                SET last_heartbeat = NOW()
                WHERE user_id  = ?
                  AND device_id = ?
                  AND session_end IS NULL 
                ORDER BY session_start DESC 
                LIMIT 1
            ");
            $stmt->bind_param("is", $user_id, $device_id);
            $stmt->execute();
            $stmt->close();
        }
        
        echo json_encode(['status' => 'success', 'message' => 'Heartbeat updated']);
    }
    
    else {
        throw new Exception('Invalid action');
    }
    
    $conn->close();
    
} catch (Exception $e) {
    error_log("Track User Error: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>