<?php
/**
 * track_time.php
 * ==============
 * تسجيل وقت المستخدم داخل التطبيق
 * يُستدعى كل دقيقة من التطبيق (heartbeat)
 *
 * @version 1.0
 * @date 2026-02-16
 */

error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);

header('Content-Type: application/json; charset=utf-8');

try {
    $conn = new mysqli("localhost", "u323701002_us_coc", "AS_05344465928pr", "u323701002_coc");

    if ($conn->connect_error) {
        throw new Exception('Database connection failed: ' . $conn->connect_error);
    }

    $conn->set_charset("utf8mb4");

    $raw_input = file_get_contents('php://input');
    $input     = json_decode($raw_input, true);

    if (!$input) {
        throw new Exception('No input data');
    }

    $user_id = isset($input['user_id']) ? intval($input['user_id']) : 0;

    if ($user_id <= 0) {
        http_response_code(400);
        exit(json_encode(['status' => 'error', 'message' => 'user_id is required']));
    }

    // التحقق أن المستخدم موجود
    $stmt = $conn->prepare("SELECT id FROM users WHERE id = ? LIMIT 1");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows === 0) {
        $stmt->close();
        http_response_code(404);
        exit(json_encode(['status' => 'error', 'message' => 'User not found']));
    }
    $stmt->close();

    // ═══════════════════════════════════════════════
    // تسجيل دقيقة واحدة في daily_actions_log
    // كل طلب = دقيقة واحدة قضاها المستخدم في التطبيق
    // ═══════════════════════════════════════════════
    $stmt = $conn->prepare("
        INSERT INTO daily_actions_log 
            (user_id, action_type, coins_earned, xp_earned, action_date)
        VALUES 
            (?, 'spend_time_in_app', 0, 0, NOW())
    ");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $stmt->close();

    $conn->close();

    echo json_encode([
        'status'  => 'success',
        'message' => 'Time tracked'
    ]);

} catch (Exception $e) {
    error_log("Track Time Error: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>