<?php
/**
 * toggle_favorite.php
 * ===================
 * إضافة أو إزالة عنصر من المفضلة
 * 
 * @version 1.0
 * @date 2026-02-05
 */

header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL);
ini_set('display_errors', 0);

require_once 'db_connect.php';

// استقبال البيانات
$input = json_decode(file_get_contents('php://input'), true);
$userId = $input['user_id'] ?? $_POST['user_id'] ?? 0;
$itemId = $input['item_id'] ?? $_POST['item_id'] ?? 0;

// التحقق من صحة البيانات
if ($userId <= 0 || $itemId <= 0) {
    http_response_code(400);
    exit(json_encode([
        'status' => 'error', 
        'message' => 'بيانات غير صالحة'
    ]));
}

try {
    // التحقق من وجود المستخدم والعنصر
    $stmt = $conn->prepare("SELECT id FROM users WHERE id = :uid");
    $stmt->execute([':uid' => $userId]);
    if (!$stmt->fetch()) {
        throw new Exception('المستخدم غير موجود');
    }
    
    $stmt = $conn->prepare("SELECT id FROM shop_items WHERE id = :iid AND is_active = TRUE");
    $stmt->execute([':iid' => $itemId]);
    if (!$stmt->fetch()) {
        throw new Exception('العنصر غير موجود');
    }
    
    // التحقق من حالة المفضلة الحالية
    $stmt = $conn->prepare(
        "SELECT id FROM user_favorite_items 
         WHERE user_id = :uid AND item_id = :iid"
    );
    $stmt->execute([':uid' => $userId, ':iid' => $itemId]);
    $isFavorite = $stmt->fetch();
    
    if ($isFavorite) {
        // إزالة من المفضلة
        $stmt = $conn->prepare(
            "DELETE FROM user_favorite_items 
             WHERE user_id = :uid AND item_id = :iid"
        );
        $stmt->execute([':uid' => $userId, ':iid' => $itemId]);
        
        $message = 'تمت إزالة العنصر من المفضلة';
        $newState = false;
    } else {
        // إضافة للمفضلة
        $stmt = $conn->prepare(
            "INSERT INTO user_favorite_items (user_id, item_id) 
             VALUES (:uid, :iid)"
        );
        $stmt->execute([':uid' => $userId, ':iid' => $itemId]);
        
        $message = 'تمت إضافة العنصر للمفضلة ⭐';
        $newState = true;
    }
    
    // مسح الكاش
    if (function_exists('apcu_delete')) {
        apcu_delete("shop_items_user_{$userId}_v2");
    }
    
    echo json_encode([
        'status' => 'success',
        'message' => $message,
        'data' => [
            'is_favorite' => $newState
        ]
    ]);

} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage()
    ]);
}
?>