<?php
echo "<h2>Testing Pusher Presence Authentication</h2>";
echo "<style>
body { font-family: Arial; padding: 20px; background: #f5f5f5; }
.success { color: green; background: #d4edda; padding: 10px; border-radius: 5px; }
.error { color: red; background: #f8d7da; padding: 10px; border-radius: 5px; }
pre { background: #fff; padding: 15px; border: 1px solid #ddd; border-radius: 5px; overflow-x: auto; }
</style>";

// محاكاة طلب من التطبيق
$_POST = [
    'socket_id' => 'test.12345',
    'channel_name' => 'presence-room-1',
    'user_id' => '215'
];

echo "<h3>1. Request Data:</h3>";
echo "<pre>";
print_r($_POST);
echo "</pre>";

echo "<h3>2. Processing Authentication...</h3>";

// تشغيل ملف التوثيق
ob_start();
try {
    include 'pusher_auth.php';
    $response = ob_get_clean();
} catch (Exception $e) {
    $response = ob_get_clean();
    echo "<div class='error'>Exception: " . $e->getMessage() . "</div>";
}

echo "<h3>3. Raw Response:</h3>";
echo "<pre>" . htmlspecialchars($response) . "</pre>";

// التحقق من صحة JSON
echo "<h3>4. Validation:</h3>";
$json = json_decode($response, true);

if (json_last_error() !== JSON_ERROR_NONE) {
    echo "<div class='error'>✗ INVALID JSON - Error: " . json_last_error_msg() . "</div>";
} else if (isset($json['status']) && $json['status'] === 'error') {
    echo "<div class='error'>✗ ERROR Response</div>";
    echo "<pre>" . print_r($json, true) . "</pre>";
} else if (isset($json['auth']) && isset($json['channel_data'])) {
    echo "<div class='success'>✓ SUCCESS - Valid Auth Response</div>";
    echo "<strong>Auth Key:</strong> " . htmlspecialchars(substr($json['auth'], 0, 30)) . "...<br>";
    
    $channel_data = json_decode($json['channel_data'], true);
    if ($channel_data) {
        echo "<strong>User ID:</strong> " . ($channel_data['user_id'] ?? 'N/A') . "<br>";
        echo "<strong>Display Name:</strong> " . ($channel_data['display_name'] ?? 'N/A') . "<br>";
        echo "<strong>Role:</strong> " . ($channel_data['role'] ?? 'N/A') . "<br>";
    }
} else {
    echo "<div class='error'>✗ UNEXPECTED Response Format</div>";
    echo "<pre>" . print_r($json, true) . "</pre>";
}

// عرض ملف السجل
echo "<hr><h3>5. Debug Log:</h3>";
$log_file = __DIR__ . '/pusher_auth_debug.log';
if (file_exists($log_file)) {
    $log_content = file_get_contents($log_file);
    $lines = explode("\n", $log_content);
    $last_lines = array_slice($lines, -30); // آخر 30 سطر
    echo "<pre>" . htmlspecialchars(implode("\n", $last_lines)) . "</pre>";
} else {
    echo "<div class='error'>Log file not found</div>";
}

// اختبار الاتصال بقاعدة البيانات
echo "<hr><h3>6. Database Connection Test:</h3>";
try {
    require_once 'db_connect.php';
    
    $stmt = $conn->query("SELECT COUNT(*) as count FROM users WHERE id = 215");
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($result['count'] > 0) {
        echo "<div class='success'>✓ User 215 exists in database</div>";
        
        $stmt2 = $conn->query("SELECT COUNT(*) as count FROM room_members WHERE user_id = 215 AND room_id = 1");
        $result2 = $stmt2->fetch(PDO::FETCH_ASSOC);
        
        if ($result2['count'] > 0) {
            echo "<div class='success'>✓ User 215 is member of room 1</div>";
        } else {
            echo "<div class='error'>✗ User 215 is NOT member of room 1</div>";
        }
    } else {
        echo "<div class='error'>✗ User 215 does NOT exist in database</div>";
    }
    
} catch (Exception $e) {
    echo "<div class='error'>✗ Database Error: " . $e->getMessage() . "</div>";
}
?>