<?php
// skip_truth_turn.php - v4 (Fixed Turn Logic + Pusher Events)
header('Content-Type: application/json; charset=utf-8');
require 'db_connect.php';
require 'fcm_sender.php';
require_once __DIR__ . '/PusherHelper.php'; // إضافة Pusher

$data = json_decode(file_get_contents('php://input'), true);
$round_id = $data['round_id'] ?? 0;

if (empty($round_id)) {
    http_response_code(400);
    exit(json_encode(['status' => 'error', 'message' => 'Round ID is required.']));
}

try {
    $conn->beginTransaction();
    
    $stmt_round = $conn->prepare("SELECT * FROM truth_game_rounds WHERE id = :round_id AND answer_text IS NULL");
    $stmt_round->execute([':round_id' => $round_id]);
    $round = $stmt_round->fetch(PDO::FETCH_ASSOC);
    
    if (!$round) {
        $conn->commit();
        exit(json_encode(['status' => 'success', 'message' => 'Round already handled.']));
    }
    
    $stmt_delete = $conn->prepare("DELETE FROM truth_game_rounds WHERE id = :round_id");
    $stmt_delete->execute([':round_id' => $round_id]);
    
    $stmt_game = $conn->prepare(
        "SELECT tg.id as game_id, c.user1_id, c.user2_id 
         FROM truth_games tg
         JOIN couples c ON tg.couple_id = c.id
         WHERE tg.id = :game_id"
    );
    $stmt_game->execute([':game_id' => $round['game_id']]);
    $game_data = $stmt_game->fetch(PDO::FETCH_ASSOC);
    
    if ($game_data) {
        // ★★★★★ التعديل: تحديد من كان يجب أن يجيب ★★★★★
        $answer_user_id = ($round['question_user_id'] == $game_data['user1_id']) 
            ? $game_data['user2_id'] 
            : $game_data['user1_id'];
        
        // الدور ينتقل لمن كان يجب أن يجيب (لأنه لم يجب في الوقت)
        $next_turn_user_id = $answer_user_id;
        
        $stmt_turn = $conn->prepare("UPDATE truth_games SET current_turn_user_id = :next_turn_user_id WHERE id = :game_id");
        $stmt_turn->execute([
            ':next_turn_user_id' => $next_turn_user_id,
            ':game_id' => $game_data['game_id']
        ]);
        
        $stmt_names = $conn->prepare("SELECT id, display_name FROM users WHERE id IN (:id1, :id2)");
        $stmt_names->execute([':id1' => $round['question_user_id'], ':id2' => $next_turn_user_id]);
        $users = $stmt_names->fetchAll(PDO::FETCH_KEY_PAIR);
        
        $skipped_user_name = $users[$next_turn_user_id] ?? 'شريكك';
        $asker_name = $users[$round['question_user_id']] ?? 'اللاعب';
        
        $message = "انتهى الوقت! لم يقم $skipped_user_name بالإجابة على سؤال $asker_name. الدور الآن على $skipped_user_name لطرح سؤال.";
        
        // إرسال FCM للطرفين
        sendFcmNotification($conn, $game_data['user1_id'], "انتهى الوقت في لعبة الصراحة", $message, ['type' => 'truth-turn-skipped']);
        sendFcmNotification($conn, $game_data['user2_id'], "انتهى الوقت في لعبة الصراحة", $message, ['type' => 'truth-turn-skipped']);
        
        // ★★★★★ إضافة Pusher Events للطرفين ★★★★★
        $pusher_data = [
            'round_id' => (int)$round_id,
            'next_turn_user_id' => (int)$next_turn_user_id,
            'skipped_user_name' => $skipped_user_name,
            'message' => $message
        ];
        
        // إرسال للمستخدم الأول
        send_pusher_trigger(
            "c0a2fe3c47f0775d0be1", 
            "85330156aec9dd641145", 
            "2109257", 
            "mt1", 
            'user-' . $game_data['user1_id'], 
            'truth-turn-skipped', 
            $pusher_data
        );
        
        // إرسال للمستخدم الثاني
        send_pusher_trigger(
            "c0a2fe3c47f0775d0be1", 
            "85330156aec9dd641145", 
            "2109257", 
            "mt1", 
            'user-' . $game_data['user2_id'], 
            'truth-turn-skipped', 
            $pusher_data
        );
    }
    
    $conn->commit();
    
    echo json_encode(['status' => 'success', 'message' => 'Turn skipped successfully.']);
    
} catch (Exception $e) {
    $conn->rollBack();
    http_response_code(500);
    error_log("Skip Turn Error: " . $e->getMessage());
    echo json_encode(['status' => 'error', 'message' => 'Server Error: ' . $e->getMessage()]);
}
?>