<?php
header('Content-Type: application/json; charset=utf-8');

error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);

require 'db_connect.php';

$rewardsEnabled = false;
$useNewRewardSystem = false;

if (file_exists('points_manager_v2.php')) {
    try {
        require 'points_manager_v2.php';
        $useNewRewardSystem = function_exists('grantRewardV2');
        $rewardsEnabled = true;
    } catch (Exception $e) {
        error_log("Failed to load points_manager_v2.php: " . $e->getMessage());
    }
}

if (!$rewardsEnabled && file_exists('points_manager.php')) {
    try {
        require 'points_manager.php';
        $rewardsEnabled = function_exists('grantReward');
    } catch (Exception $e) {
        error_log("Failed to load points_manager.php: " . $e->getMessage());
    }
}

function get_google_api_access_token() {
    $private_key_pem = "-----BEGIN PRIVATE KEY-----\n" .
    "MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCztW431tOFhOyI\n" .
    "1TJjKeJKVYaFtHCoXsXwsRPwStxvrQihKHVMaNQTc20XMQW8gAXhWVl6FCBAWtky\n" .
    "UbnQGEg8QK1eU+mK1XvzjylgfLzj0ASUaepDKeI97P80lgaw2T4hELAIh+CO5sKu\n" .
    "oYVpnWxevcZuVPDgz+hSdzRtW+o8BaWVn/41xWcjmFaMayBVrRoGrbtgyeyQPXLj\n" .
    "HJihvm+n2YL4kd/FA+z26/6KTCRgaUqkX/Wjr0Xyxd5lcmZBlHvLuS3N/VjMLwIJ\n8TMEo4TO5YU4vhFc2LlWNLbBAin9D7oQcHK1nEuQl3oeLAt6zJORdjBD6lqROIyX\n+h9iGlVLAgMBAAECggEAATbAkOKhAcamlF7xv8cXPXGSuNGqbg3PpgSEMKTUcbfC\n" .
    "c3si+vi9ZCtVp+YJ06dcFywWvgvEql2HGII8W/C2DJBSu3hWFnc2+CuzEeVeh/3F\n" .
    "lQ6DXf0L8CGZpPr4ct9FhEzXmhrJOKmGGiAlorCWZPH68jJ6mA3LGf1RgZE8mgjn\n" .
    "6FqNkX4Ih2/oJKlo9fqLqzerkj4zceeoAAouZZIg6uM4lSOF4w2bqykDeq6OVvpG\n" .
    "8it+0asrFhCRsJhb0Qfm//+/lVmekMAH2TLS3kmju8KveDsjwX79na61wFNuhZKe\n" .
    "Qa2lLSK1HWmK/5PDtw191qRgOi4ijXP+Pm47bIk7gQKBgQDt0Ggf0ILpPzJA1Lsk\n" .
    "6UZ9qDNDaQlfDXWn6XXQaY4QLAOgxsZnRJetwJk0X/PLVTEOVDO2FUCM6byDXYjL\n" .
    "K9xF5cZHV1tmDNG79kH3Dm03ZrAp8371LgOQPjtQq9nh4G98erUZlCq0yUPEiTh9\n" .
    "7GT92Qktds4JMoiLoEzgM5YIywKBgQDBc4SC64yNtQrF7QstKyD4+v/3X715SclL\n" .
    "I0nzPEZhk8fj7n52xnpkW2L0MF7asYr5yZiG6DTuGoF+USTM7z3beoghk4+6cHoU\n" .
    "L1EXaY0CBhppYcGaCn6CazEBfc0u9Bc7LdqAm46fJa55ZWfUysT2nMfF/tGBKNp/\n" .
    "5PmWN63VgQKBgQCtk0GMhwol6GRrgVme1U0IBi50c0PNxusrRXEiTwjLsPRs8uh5\n" .
    "E02KGls4KRiuPl3x0W905QoaT7eyQiDH+hlqQw13oMErOQwUHueCxVrd5uuJkxoF\n" .
    "JjKfo2xzsxryjHeS6ZUpOEX7cjMuTeGXt2T3CuRx9Jbpi6KyFqxFsCFABQKBgF8f\n" .
    "DxxU+FLBn599FE7MczUaLnyTrhYSixEQNA+PJshaIyLXpYV/yLTKHtkVY77DKCP0\n" .
    "1bQYP9aIX/4dpivCw7bFBGUGKtkw70Y3kfciJnzFRX1l3Q2CdXxperpSAm9BBJ9L\n" .
    "x7IPS0zD+Yulqi1+2uSsaKrZxmhtDytuCq+rhyWBAoGAFzHTW3L8skBiLfmoFQ36\n" .
    "5CoOpblHIXoKp7Ctl6ARrID1W/HzU0SA6jUyIQg69B7bpeic7GJcyxaBSg57w/Ri\n" .
    "KsOPj2nJ0J/xbULrbbzXkE0yoUU4dUMSxCbE24idRVaBZVUbQti6ABgH0NyfHpz2\n" .
    "8tvJUtYUcbdMaocWK5FD0Pw=\n" .
    "-----END PRIVATE KEY-----";
    $client_email = "firebase-adminsdk-fbsvc@couple-d1a57.iam.gserviceaccount.com";
    $token_uri = "https://oauth2.googleapis.com/token";
    $header = rtrim(strtr(base64_encode(json_encode(['alg' => 'RS256', 'typ' => 'JWT'] )), '+/', '-_'), '=');
    $now = time();
    $payload = rtrim(strtr(base64_encode(json_encode(['iss' => $client_email, 'scope' => 'https://www.googleapis.com/auth/cloud-platform', 'aud' => $token_uri, 'exp' => $now + 3600, 'iat' => $now] )), '+/', '-_'), '=');
    $signature = '';
    openssl_sign("$header.$payload", $signature, $private_key_pem, 'sha256');
    $jwt = "$header.$payload." . rtrim(strtr(base64_encode($signature), '+/', '-_'), '=');
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $token_uri);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(['grant_type' => 'urn:ietf:params:oauth:grant-type:jwt-bearer', 'assertion' => $jwt] ));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);
    $data = json_decode($response, true);
    return $data['access_token'] ?? null;
}

function sendFcmNotification($target, $data_payload) {
    $access_token = get_google_api_access_token();
    if (!$access_token) return; 
    $fcm_url = "https://fcm.googleapis.com/v1/projects/couple-d1a57/messages:send";
    $target_field = (strpos($target, '/topics/' ) === 0) ? 'topic' : 'token';
    $message = ['message' => [$target_field => $target, 'data' => $data_payload]];
    $headers = ['Authorization: Bearer ' . $access_token, 'Content-Type: application/json'];
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $fcm_url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($message));
    $result = curl_exec($ch);
    curl_close($ch);
    
    error_log("FCM Notification sent with payload: " . json_encode($data_payload));
    error_log("FCM Response: " . $result);
}

$json = file_get_contents('php://input');
$data = json_decode($json, true);
$sender_id = $data['sender_id'] ?? $_POST['sender_id'] ?? 0;
$signal_type = $data['signal_type'] ?? $_POST['signal_type'] ?? '';

if (empty($sender_id) || empty($signal_type)) {
    exit(json_encode(['status' => 'error', 'message' => 'Missing data']));
}

try {
    $stmt = $conn->prepare("SELECT u.display_name, u.couple_id, p.fcm_token as partner_fcm_token 
                            FROM users u 
                            LEFT JOIN users p ON u.couple_id = p.couple_id AND p.id != u.id 
                            WHERE u.id = :sender_id LIMIT 1");
    $stmt->execute([':sender_id' => $sender_id]);
    $user_data = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user_data || empty($user_data['couple_id'])) {
        throw new Exception("Couple not found for this user.");
    }

    $couple_id = $user_data['couple_id'];
    $sender_name = $user_data['display_name'];
    $partner_fcm_token = $user_data['partner_fcm_token'];

    $column = '';
    if ($signal_type == 'love') $column = 'love_signals_count';
    elseif ($signal_type == 'sad') $column = 'sad_signals_count';
    elseif ($signal_type == 'missing') $column = 'missing_signals_count';

    if (!empty($column)) {
        $upd = $conn->prepare("UPDATE couples SET $column = $column + 1 WHERE id = :cid");
        $upd->execute([':cid' => $couple_id]);

        $ins = $conn->prepare("INSERT INTO signals (sender_id, couple_id, type, created_at) VALUES (:sid, :cid, :type, NOW())");
        $ins->execute([':sid' => $sender_id, ':cid' => $couple_id, ':type' => $signal_type]);
        
        $rewardData = null;
        if ($rewardsEnabled) {
            try {
                if ($useNewRewardSystem) {
                    $rewardData = grantRewardV2($conn, $sender_id, 'send_signal');
                } else {
                    $rewardData = grantReward($conn, $sender_id, 'send_signal');
                }
                error_log("Reward granted for user $sender_id");
            } catch (Exception $rewardError) {
                error_log("Reward grant failed: " . $rewardError->getMessage());
            }
        }
    }

    if (!empty($partner_fcm_token)) {
        $customSound = '';
        if ($signal_type == 'love') {
            $customSound = 'love_signal';
        } elseif ($signal_type == 'sad') {
            $customSound = 'sad_signal';
        } elseif ($signal_type == 'missing') {
            $customSound = 'missing_signal';
        }

        $signalText = '';
        if ($signal_type == 'love') $signalText = 'حب ❤️';
        elseif ($signal_type == 'sad') $signalText = 'حزن 😔';
        elseif ($signal_type == 'missing') $signalText = 'اشتياق 💌';

        $payload = [
            'type' => $signal_type . '_signal',
            'title' => 'إشارة ' . $signalText,
            'body' => $sender_name . ' أرسل لك إشارة ' . $signalText,
            'action' => 'refresh_dashboard',
            'sound' => $customSound
        ];
        
        sendFcmNotification($partner_fcm_token, $payload);
    }

    $response = [
        'status' => 'success',
        'message' => 'تم إرسال الإشارة بنجاح',
        'rewards_enabled' => $rewardsEnabled,
        'data' => [
            'signal_type' => $signal_type,
            'partner_token' => $partner_fcm_token
        ]
    ];
    
    if ($rewardData !== null) {
        $response['data']['reward'] = $rewardData;
    }
    
    echo json_encode($response);

} catch (Exception $e) {
    error_log("Signal send error: " . $e->getMessage());
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>