<?php
ini_set('display_errors', 0);
error_reporting(E_ALL);

if (ob_get_level()) {
    ob_end_clean();
}
header('Content-Type: application/json; charset=utf-8');

require 'db_connect.php';

$rewardsEnabled = false;
$useNewRewardSystem = false;
if (file_exists(__DIR__ . '/points_manager_v2.php')) {
    try {
        require_once __DIR__ . '/points_manager_v2.php';
        $useNewRewardSystem = function_exists('grantRewardV2');
        $rewardsEnabled = true;
    } catch (Exception $e) {
        error_log("Failed to load points_manager_v2.php: " . $e->getMessage());
    }
}

$pusher_available = false;
if (file_exists(__DIR__ . '/PusherHelper.php')) {
    try {
        require_once __DIR__ . '/PusherHelper.php';
        $pusher_available = function_exists('send_pusher_trigger');
    } catch (Exception $e) {
        error_log("PusherHelper error: " . $e->getMessage());
    }
}

$data = json_decode(file_get_contents('php://input'), true);

$userId = isset($data['user_id']) ? (int)$data['user_id'] : 0;
$roomId = isset($data['room_id']) ? (int)$data['room_id'] : 0;
$messageText = isset($data['message_text']) ? trim($data['message_text']) : '';

if ($userId <= 0 || $roomId <= 0 || empty($messageText)) {
    http_response_code(400);
    die(json_encode(['status' => 'error', 'message' => 'بيانات غير مكتملة']));
}

$conn->beginTransaction();

try {
    $stmt_member = $conn->prepare("SELECT role FROM room_members WHERE room_id = :room_id AND user_id = :user_id");
    $stmt_member->execute([':room_id' => $roomId, ':user_id' => $userId]);
    if (!$stmt_member->fetch()) {
        throw new Exception("أنت لست عضواً في هذه الغرفة");
    }
    
    $stmt_banned = $conn->prepare("SELECT 1 FROM room_banned_users WHERE room_id = :room_id AND user_id = :user_id");
    $stmt_banned->execute([':room_id' => $roomId, ':user_id' => $userId]);
    if ($stmt_banned->fetch()) {
        throw new Exception("أنت محظور من هذه الغرفة");
    }
    
    $stmt = $conn->prepare("INSERT INTO room_messages (room_id, user_id, message_text, is_system) VALUES (:room_id, :user_id, :message_text, 0)");
    $stmt->execute([
        ':room_id' => $roomId,
        ':user_id' => $userId,
        ':message_text' => $messageText
    ]);
    
    $messageId = $conn->lastInsertId();
    $timestamp = date("Y-m-d H:i:s");
    
    $stmt_user = $conn->prepare("SELECT display_name, level, profile_image_url, frame_identifier, name_color, font_identifier, is_verified FROM users WHERE id = :user_id");
    $stmt_user->execute([':user_id' => $userId]);
    $user = $stmt_user->fetch(PDO::FETCH_ASSOC);
    
    $rewardData = null;
    if ($rewardsEnabled) {
        try {
            $rewardFunction = $useNewRewardSystem ? 'grantRewardV2' : 'grantReward';
            $rewardData = $rewardFunction($conn, $userId, 'send_message');
        } catch (Exception $rewardError) {
            error_log("Reward error: " . $rewardError->getMessage());
        }
    }
    
    if ($pusher_available) {
        try {
            send_pusher_trigger(
                "c0a2fe3c47f0775d0be1",
                "85330156aec9dd641145",
                "2109257",
                "mt1",
                'presence-room-' . $roomId,
                'new-message',
                [
                    'id' => (int)$messageId,
                    'room_id' => $roomId,
                    'user_id' => $userId,
                    'user_name' => $user['display_name'],
                    'user_level' => (int)$user['level'],
                    'user_image_url' => $user['profile_image_url'],
                    'frame_identifier' => $user['frame_identifier'],
                    'name_color' => $user['name_color'],
                    'font_identifier' => $user['font_identifier'],
                    'is_verified' => (int)$user['is_verified'],
                    'message_text' => $messageText,
                    'is_system' => false,
                    'created_at' => $timestamp
                ]
            );
        } catch (Exception $e) {
            error_log("Pusher failed: " . $e->getMessage());
        }
    }
    
    $conn->commit();
    
    $response = [
        'status' => 'success',
        'data' => [
            'id' => (int)$messageId,
            'room_id' => $roomId,
            'user_id' => $userId,
            'message_text' => $messageText,
            'created_at' => $timestamp
        ]
    ];
    
    if ($rewardData !== null) {
        $response['data']['reward'] = $rewardData;
    }
    
    echo json_encode($response);

} catch (Exception $e) {
    if ($conn->inTransaction()) {
        $conn->rollBack();
    }
    http_response_code(500);
    error_log("Send room message error: " . $e->getMessage());
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>