<?php
ini_set('display_errors', 0);
error_reporting(E_ALL);

if (ob_get_level()) {
    ob_end_clean();
}

header('Content-Type: application/json; charset=utf-8');

require 'db_connect.php';

$rewardsEnabled = false;
$useNewRewardSystem = false;

if (file_exists(__DIR__ . '/points_manager_v2.php')) {
    try {
        require_once __DIR__ . '/points_manager_v2.php';
        $useNewRewardSystem = function_exists('grantRewardV2');
        $rewardsEnabled = true;
    } catch (Exception $e) {
        error_log("Failed to load points_manager_v2.php: " . $e->getMessage());
    }
}

if (!$rewardsEnabled && file_exists(__DIR__ . '/points_manager.php')) {
    try {
        require_once __DIR__ . '/points_manager.php';
        $rewardsEnabled = function_exists('grantReward');
    } catch (Exception $e) {
        error_log("Failed to load points_manager.php: " . $e->getMessage());
    }
}

$pusher_available = false;
$fcm_available = false;

if (file_exists(__DIR__ . '/PusherHelper.php')) {
    try {
        require_once __DIR__ . '/PusherHelper.php';
        $pusher_available = function_exists('send_pusher_trigger');
    } catch (Exception $e) {
        error_log("PusherHelper error: " . $e->getMessage());
    }
}

if (file_exists(__DIR__ . '/fcm_sender.php')) {
    try {
        require_once __DIR__ . '/fcm_sender.php';
        $fcm_available = function_exists('sendFcmNotification');
    } catch (Exception $e) {
        error_log("FCM error: " . $e->getMessage());
    }
}

$data = json_decode(file_get_contents('php://input'), true);

$senderId = isset($data['sender_id']) ? (int)$data['sender_id'] : 0;
$recipientId = isset($data['recipient_id']) ? (int)$data['recipient_id'] : 0;
$messageText = isset($data['message_text']) ? trim($data['message_text']) : '';
$senderName = isset($data['sender_name']) ? trim($data['sender_name']) : 'شخص ما';

if ($senderId <= 0 || $recipientId <= 0 || empty($messageText)) {
    http_response_code(400);
    die(json_encode(['status' => 'error', 'message' => 'بيانات الرسالة غير مكتملة.']));
}

if ($conn instanceof PDO) {
    $conn->beginTransaction();
}

try {
    $stmt_check_block = $conn->prepare(
        "SELECT 1 FROM blocked_users 
         WHERE (blocker_id = :senderId AND blocked_id = :recipientId) 
            OR (blocker_id = :recipientId AND blocked_id = :senderId)"
    );
    $stmt_check_block->execute(['senderId' => $senderId, 'recipientId' => $recipientId]);
    if ($stmt_check_block->fetch()) {
        throw new Exception("لا يمكنك إرسال رسالة لهذا المستخدم.");
    }

    $message_status = 'sent';
    $is_new_request = false;
    $should_grant_reward = false;

    $stmt_partner = $conn->prepare(
        "SELECT id FROM couples 
         WHERE (user1_id = :sender AND user2_id = :recipient) 
            OR (user1_id = :recipient AND user2_id = :sender)"
    );
    $stmt_partner->execute([':sender' => $senderId, ':recipient' => $recipientId]);
    $are_partners = $stmt_partner->fetch();

    if (!$are_partners) {
        $stmt_convo = $conn->prepare(
            "SELECT id FROM messages 
             WHERE ((sender_id = :sender AND recipient_id = :recipient) 
                OR (sender_id = :recipient AND recipient_id = :sender)) 
               AND status != 'request' 
             LIMIT 1"
        );
        $stmt_convo->execute([':sender' => $senderId, ':recipient' => $recipientId]);
        $convo_exists = $stmt_convo->fetch();

        if (!$convo_exists) {
            $stmt_pending = $conn->prepare(
                "SELECT id FROM messages 
                 WHERE sender_id = :sender AND recipient_id = :recipient AND status = 'request' 
                 LIMIT 1"
            );
            $stmt_pending->execute([':sender' => $senderId, ':recipient' => $recipientId]);
            if ($stmt_pending->fetch()) {
                if ($conn instanceof PDO && $conn->inTransaction()) {
                    $conn->rollBack();
                }
                die(json_encode([
                    'status' => 'error',
                    'message' => 'لم يتم قبول طلب المراسلة بعد. انتظر حتى يقبل الطلب.',
                    'error_type' => 'pending_request'
                ]));
            }

            $message_status = 'request';
            $is_new_request = true;
            $should_grant_reward = false;
        } else {
            $should_grant_reward = true;
        }
    } else {
        $should_grant_reward = true;
    }

    $stmt = $conn->prepare(
        "INSERT INTO messages (sender_id, recipient_id, message_text, status) 
         VALUES (:senderId, :recipientId, :messageText, :status)"
    );
    $stmt->execute([
        'senderId' => $senderId,
        'recipientId' => $recipientId,
        'messageText' => $messageText,
        'status' => $message_status
    ]);
    $messageId = $conn->lastInsertId();
    $timestamp = date("Y-m-d H:i:s");

    $rewardData = null;
    if ($should_grant_reward && $rewardsEnabled) {
        try {
            if ($useNewRewardSystem) {
                $rewardData = grantRewardV2($conn, $senderId, 'send_message');
            } else {
                $rewardData = grantReward($conn, $senderId, 'send_message');
            }
        } catch (Exception $rewardError) {
            error_log("Reward error: " . $rewardError->getMessage());
        }
    }

    if ($is_new_request) {
        if ($fcm_available) {
            try {
                sendFcmNotification(
                    $conn, 
                    $recipientId, 
                    "لديك طلب مراسلة جديد!", 
                    "$senderName يريد مراسلتك.", 
                    ['type' => 'message_request', 'sender_id' => (string)$senderId]
                );
            } catch (Exception $e) {
                error_log("FCM failed: " . $e->getMessage());
            }
        }
        
        if ($pusher_available) {
            try {
                send_pusher_trigger(
                    "c0a2fe3c47f0775d0be1", 
                    "85330156aec9dd641145", 
                    "2109257", 
                    "mt1", 
                    'user-' . $recipientId, 
                    'new-message-request', 
                    ['new_request' => true, 'sender_id' => $senderId]
                );
            } catch (Exception $e) {
                error_log("Pusher failed: " . $e->getMessage());
            }
        }
    } else {
        if ($fcm_available) {
            try {
                sendFcmNotification(
                    $conn, 
                    $recipientId, 
                    "رسالة جديدة من $senderName", 
                    $messageText, 
                    ['type' => 'new_message', 'sender_id' => (string)$senderId]
                );
            } catch (Exception $e) {
                error_log("FCM failed: " . $e->getMessage());
            }
        }

        if ($pusher_available) {
            try {
                $chat_channel = 'chat-' . min($senderId, $recipientId) . '-' . max($senderId, $recipientId);
                send_pusher_trigger(
                    "c0a2fe3c47f0775d0be1", 
                    "85330156aec9dd641145", 
                    "2109257", 
                    "mt1", 
                    $chat_channel, 
                    'new-message', 
                    [
                        'id' => (int)$messageId,
                        'sender_id' => $senderId,
                        'recipient_id' => $recipientId,
                        'message_text' => $messageText,
                        'created_at' => $timestamp,
                        'status' => $message_status
                    ]
                );

                send_pusher_trigger(
                    "c0a2fe3c47f0775d0be1", 
                    "85330156aec9dd641145", 
                    "2109257", 
                    "mt1", 
                    'user-' . $recipientId, 
                    'conversation-update', 
                    [
                        'partner_id' => $senderId,
                        'last_message' => $messageText,
                        'last_message_timestamp' => "الآن",
                        'status' => $message_status
                    ]
                );
            } catch (Exception $e) {
                error_log("Pusher failed: " . $e->getMessage());
            }
        }
    }
    
    if ($conn instanceof PDO) {
        $conn->commit();
    }

    if ($is_new_request) {
        $response = [
            'status' => 'success',
            'data' => [
                'is_request' => true,
                'id' => (int)$messageId,
                'sender_id' => $senderId,
                'recipient_id' => $recipientId,
                'message_text' => $messageText,
                'created_at' => $timestamp,
                'status' => $message_status
            ]
        ];
    } else {
        $stmt_token = $conn->prepare("SELECT fcm_token FROM users WHERE id = :recipientId");
        $stmt_token->execute(['recipientId' => $recipientId]);
        $recipient = $stmt_token->fetch(PDO::FETCH_ASSOC);
        $recipientToken = $recipient ? ($recipient['fcm_token'] ?? null) : null;

        $response = [
            'status' => 'success',
            'data' => [
                'is_request' => false,
                'partner_token' => $recipientToken,
                'id' => (int)$messageId,
                'sender_id' => $senderId,
                'recipient_id' => $recipientId,
                'message_text' => $messageText,
                'created_at' => $timestamp,
                'status' => $message_status
            ]
        ];

        if ($rewardData !== null) {
            $response['data']['reward'] = $rewardData;
        }
    }
    
    die(json_encode($response));

} catch (Exception $e) {
    if ($conn instanceof PDO && $conn->inTransaction()) {
        $conn->rollBack();
    }
    http_response_code(500);
    error_log("Send message error: " . $e->getMessage());
    die(json_encode(['status' => 'error', 'message' => $e->getMessage()]));
}
?>