<?php
/**
 * save_vip_settings.php
 * =====================
 * حفظ الشارات المختارة من المستخدم
 * POST: { user_id, badge_ids: [1, 3, 5] }
 */
header('Content-Type: application/json; charset=utf-8');
require 'db_connect.php';

$data     = json_decode(file_get_contents('php://input'), true);
$userId   = isset($data['user_id'])   ? (int)$data['user_id'] : 0;
$badgeIds = $data['badge_ids'] ?? [];

if (!$userId) {
    http_response_code(400);
    exit(json_encode(['status' => 'error', 'message' => 'User ID مطلوب']));
}

try {
    // جلب باقة المستخدم
    $stmt = $conn->prepare("SELECT vip_tier, vip_expires_at FROM users WHERE id = :id");
    $stmt->execute([':id' => $userId]);
    $user = $stmt->fetch();

    if (!$user) {
        exit(json_encode(['status' => 'error', 'message' => 'المستخدم غير موجود']));
    }

    // التحقق من أن الاشتراك نشط
    $vipIsActive = $user['vip_tier'] !== 'none'
        && ($user['vip_expires_at'] === null || strtotime($user['vip_expires_at']) > time());

    if (!$vipIsActive) {
        exit(json_encode(['status' => 'error', 'message' => 'لا يوجد اشتراك VIP نشط']));
    }

    // حد الشارات حسب الباقة
    $maxBadges = ['basic' => 1, 'silver' => 3, 'gold' => 5];
    $max = $maxBadges[$user['vip_tier']] ?? 1;

    if (!is_array($badgeIds)) $badgeIds = [];
    $badgeIds = array_map('intval', array_filter($badgeIds));

    if (count($badgeIds) > $max) {
        exit(json_encode([
            'status'  => 'error',
            'message' => "الحد الأقصى {$max} شارات لباقتك"
        ]));
    }

    // التحقق أن الشارات متاحة لهذه الباقة
    // الباقات الأعلى تشمل الأدنى
    $tierOrder = ['basic' => 1, 'silver' => 2, 'gold' => 3];
    $userTierOrder = $tierOrder[$user['vip_tier']];

    if (!empty($badgeIds)) {
        $placeholders = implode(',', array_fill(0, count($badgeIds), '?'));
        $checkStmt = $conn->prepare(
            "SELECT id, available_for FROM vip_badges WHERE id IN ($placeholders)"
        );
        $checkStmt->execute($badgeIds);
        $foundBadges = $checkStmt->fetchAll();

        foreach ($foundBadges as $badge) {
            $badgeTierOrder = $tierOrder[$badge['available_for']] ?? 99;
            if ($badgeTierOrder > $userTierOrder) {
                exit(json_encode([
                    'status'  => 'error',
                    'message' => 'بعض الشارات غير متاحة لباقتك'
                ]));
            }
        }
    }

    // حفظ الشارات
    $badgesJson = json_encode(array_values($badgeIds));
    $updateStmt = $conn->prepare("UPDATE users SET vip_badges = :badges WHERE id = :id");
    $updateStmt->execute([':badges' => $badgesJson, ':id' => $userId]);

    echo json_encode(['status' => 'success', 'message' => 'تم حفظ الشارات بنجاح']);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>