<?php
// respond_to_request.php (v5 - Clean & Fixed)

header('Content-Type: application/json; charset=utf-8');

require_once __DIR__ . '/PusherHelper.php'; 
require 'db_connect.php';

$data = json_decode(file_get_contents('php://input'), true);

$currentUserId = isset($data['user_id']) ? (int)$data['user_id'] : 0;
$response = isset($data['response']) ? $data['response'] : '';
$requestType = isset($data['request_type']) ? $data['request_type'] : '';

if (empty($currentUserId) || !in_array($response, ['accepted', 'declined']) || empty($requestType)) {
    http_response_code(400);
    die(json_encode(['status' => 'error', 'message' => 'بيانات الطلب غير صالحة.']));
}

if ($requestType === 'connection') {
    // ═══════════════════════════════════
    // طلبات الارتباط
    // ═══════════════════════════════════
    $requestId = isset($data['request_id']) ? (int)$data['request_id'] : 0;
    if (empty($requestId)) {
        http_response_code(400);
        die(json_encode(['status' => 'error', 'message' => 'Request ID مفقود.']));
    }

    if ($conn instanceof PDO) $conn->beginTransaction();
    
    try {
        // جلب بيانات الطلب
        $stmt = $conn->prepare(
            "SELECT requester_id, recipient_id 
             FROM connection_requests 
             WHERE id = :requestId 
               AND recipient_id = :currentUserId 
               AND status = 'pending'"
        );
        $stmt->execute([
            ':requestId' => $requestId, 
            ':currentUserId' => $currentUserId
        ]);
        $request = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$request) {
            throw new Exception("طلب الارتباط غير موجود أو تم الرد عليه.");
        }

        $requesterId = (int)$request['requester_id'];
        $recipientId = (int)$request['recipient_id'];

        // تحديث حالة الطلب
        $stmt_update = $conn->prepare(
            "UPDATE connection_requests 
             SET status = :response 
             WHERE id = :requestId"
        );
        $stmt_update->execute([
            ':response' => $response, 
            ':requestId' => $requestId
        ]);

        if ($response === 'accepted') {
            // إنشاء الارتباط
            $stmt_insert = $conn->prepare(
                "INSERT INTO couples (user1_id, user2_id, start_date) 
                 VALUES (:u1, :u2, NOW())"
            );
            $stmt_insert->execute([
                ':u1' => $requesterId, 
                ':u2' => $recipientId
            ]);
            $coupleId = $conn->lastInsertId();

            // تحديث couple_id للمستخدمين
            $stmt_update_users = $conn->prepare(
                "UPDATE users 
                 SET couple_id = :cid 
                 WHERE id = :id_a OR id = :id_b"
            );
            $stmt_update_users->execute([
                ':cid' => $coupleId, 
                ':id_a' => $requesterId, 
                ':id_b' => $recipientId
            ]);

            // رفض الطلبات الأخرى
            $stmt_decline = $conn->prepare(
                "UPDATE connection_requests 
                 SET status = 'declined' 
                 WHERE (requester_id = :u1 OR recipient_id = :u1 
                     OR requester_id = :u2 OR recipient_id = :u2) 
                   AND status = 'pending'"
            );
            $stmt_decline->execute([
                ':u1' => $requesterId, 
                ':u2' => $recipientId
            ]);

            // إرسال Pusher events
            try {
                $pusher_data = ['status' => 'linked'];
                send_pusher_trigger(
                    "c0a2fe3c47f0775d0be1", 
                    "85330156aec9dd641145", 
                    "2109257", 
                    "mt1", 
                    'user-' . $requesterId, 
                    'status-update', 
                    $pusher_data
                );
                send_pusher_trigger(
                    "c0a2fe3c47f0775d0be1", 
                    "85330156aec9dd641145", 
                    "2109257", 
                    "mt1", 
                    'user-' . $recipientId, 
                    'status-update', 
                    $pusher_data
                );
            } catch (Exception $e) {
                error_log("Pusher error: " . $e->getMessage());
            }
        }
        
        if ($conn instanceof PDO) $conn->commit();

        $message = $response === 'accepted' ? 'تم الارتباط بنجاح!' : 'تم رفض الطلب.';
        die(json_encode([
            'status' => 'success', 
            'message' => $message,
            'data' => ['decision' => $response]
        ]));

    } catch (Exception $e) {
        if ($conn instanceof PDO && $conn->inTransaction()) {
            $conn->rollBack();
        }
        http_response_code(500);
        error_log("Connection request error: " . $e->getMessage());
        die(json_encode(['status' => 'error', 'message' => $e->getMessage()]));
    }

} elseif ($requestType === 'message') {
    // ═══════════════════════════════════
    // طلبات المراسلة
    // ═══════════════════════════════════
    $senderId = isset($data['sender_id']) ? (int)$data['sender_id'] : 0;
    if (empty($senderId)) {
        http_response_code(400);
        die(json_encode(['status' => 'error', 'message' => 'Sender ID مفقود.']));
    }

    try {
        if ($response === 'accepted') {
            // قبول: تحويل حالة الرسائل من 'request' إلى 'sent'
            $stmt = $conn->prepare(
                "UPDATE messages 
                 SET status = 'sent' 
                 WHERE sender_id = :sender_id 
                   AND recipient_id = :user_id 
                   AND status = 'request'"
            );
            $message = "تم قبول طلب المراسلة.";
        } else {
            // رفض: حذف رسائل الطلب
            $stmt = $conn->prepare(
                "DELETE FROM messages 
                 WHERE sender_id = :sender_id 
                   AND recipient_id = :user_id 
                   AND status = 'request'"
            );
            $message = "تم رفض طلب المراسلة.";
        }
        
        $stmt->execute([
            ':sender_id' => $senderId, 
            ':user_id' => $currentUserId
        ]);

        // إرسال Pusher event للمُرسل
        try {
            $pusher_data = [
                'decision' => $response, 
                'responder_id' => $currentUserId
            ];
            send_pusher_trigger(
                "c0a2fe3c47f0775d0be1", 
                "85330156aec9dd641145", 
                "2109257", 
                "mt1", 
                'user-' . $senderId, 
                'message-request-response', 
                $pusher_data
            );
        } catch (Exception $e) {
            error_log("Pusher error: " . $e->getMessage());
        }

        die(json_encode(['status' => 'success', 'message' => $message]));

    } catch (Exception $e) {
        http_response_code(500);
        error_log("Message request error: " . $e->getMessage());
        die(json_encode(['status' => 'error', 'message' => $e->getMessage()]));
    }

} else {
    http_response_code(400);
    die(json_encode(['status' => 'error', 'message' => 'نوع الطلب غير معروف.']));
}