<?php
// reset_leaderboard.php
// هذا السكربت يجب أن يتم تشغيله بواسطة Cron Job مرة واحدة أسبوعيًا.

// تجاهل طلبات المستخدم ومنع الوصول المباشر عبر المتصفح
if (php_sapi_name() !== 'cli' && substr($_SERVER['REMOTE_ADDR'], 0, 4) !== '127.' && $_SERVER['REMOTE_ADDR'] !== '::1') {
    http_response_code(403 );
    die("Access Denied. This script can only be run from the command line or localhost.");
}

require 'db_connect.php';

// إعدادات
$limit = 3; // حفظ المراكز الثلاثة الأولى فقط
$today = date("Y-m-d");

// استخدام Transaction لضمان تنفيذ كل العمليات معًا أو عدم تنفيذ أي منها
$conn->beginTransaction();

try {
    // --- القسم الأول: معالجة لوحة صدارة الأفراد (حسب المستوى) ---
    echo "Processing Individuals Leaderboard...\n";

    $stmt_individuals = $conn->prepare(
        "SELECT id, display_name, profile_image_url, level 
         FROM users 
         ORDER BY level DESC, xp DESC 
         LIMIT :limit"
    );
    $stmt_individuals->bindValue(':limit', $limit, PDO::PARAM_INT);
    $stmt_individuals->execute();
    $top_individuals = $stmt_individuals->fetchAll(PDO::FETCH_ASSOC);

    $rank = 1;
    foreach ($top_individuals as $user) {
        $stmt_insert = $conn->prepare(
            "INSERT INTO leaderboard_history (winner_type, `rank`, user1_id, user1_name, user1_image_url, score, win_date) 
             VALUES ('individual', :rank, :user_id, :user_name, :user_image, :score, :win_date)"
        );
        $stmt_insert->execute([
            ':rank' => $rank,
            ':user_id' => $user['id'],
            ':user_name' => $user['display_name'],
            ':user_image' => $user['profile_image_url'],
            ':score' => $user['level'],
            ':win_date' => $today
        ]);
        $rank++;
    }
    echo count($top_individuals) . " individual winners have been archived.\n";

    // --- القسم الثاني: معالجة لوحة صدارة الأزواج (حسب نقاط الحب) ---
    echo "Processing Couples Leaderboard...\n";

    $stmt_couples = $conn->prepare(
       "SELECT 
            c.id AS couple_id,
            (c.love_signals_count * 5 - c.sad_signals_count * 3) AS love_meter,
            u1.id AS user1_id, u1.display_name AS user1_name, u1.profile_image_url AS user1_image_url,
            u2.id AS user2_id, u2.display_name AS user2_name, u2.profile_image_url AS user2_image_url
        FROM couples c
        JOIN users u1 ON c.user1_id = u1.id
        JOIN users u2 ON c.user2_id = u2.id
        ORDER BY love_meter DESC
        LIMIT :limit"
    );
    $stmt_couples->bindValue(':limit', $limit, PDO::PARAM_INT);
    $stmt_couples->execute();
    $top_couples = $stmt_couples->fetchAll(PDO::FETCH_ASSOC);

    $rank = 1;
    foreach ($top_couples as $couple) {
        $stmt_insert = $conn->prepare(
            "INSERT INTO leaderboard_history (winner_type, `rank`, user1_id, user1_name, user1_image_url, user2_id, user2_name, user2_image_url, score, win_date) 
             VALUES ('couple', :rank, :user1_id, :user1_name, :user1_image, :user2_id, :user2_name, :user2_image, :score, :win_date)"
        );
        $stmt_insert->execute([
            ':rank' => $rank,
            ':user1_id' => $couple['user1_id'],
            ':user1_name' => $couple['user1_name'],
            ':user1_image' => $couple['user1_image_url'],
            ':user2_id' => $couple['user2_id'],
            ':user2_name' => $couple['user2_name'],
            ':user2_image' => $couple['user2_image_url'],
            ':score' => max(0, (int)$couple['love_meter']),
            ':win_date' => $today
        ]);
        $rank++;
    }
    echo count($top_couples) . " couple winners have been archived.\n";

    // --- القسم الثالث: إعادة تعيين النقاط ---
    echo "Resetting scores...\n";

    // إعادة تعيين نقاط المستوى والخبرة لجميع المستخدمين
    $conn->exec("UPDATE users SET level = 1, xp = 0");
    echo "All user levels and XP have been reset.\n";

    // إعادة تعيين نقاط الحب لجميع الأزواج
    $conn->exec("UPDATE couples SET love_signals_count = 0, sad_signals_count = 0");
    echo "All couple signal counts have been reset.\n";

    // تأكيد كل التغييرات
    $conn->commit();
    echo "Leaderboard reset completed successfully!\n";

} catch (Exception $e) {
    // في حالة حدوث أي خطأ، تراجع عن كل التغييرات
    $conn->rollBack();
    // تسجيل الخطأ في سجلات الخادم
    error_log("Leaderboard Reset Failed: " . $e->getMessage());
    // إرسال رسالة خطأ
    echo "An error occurred: " . $e->getMessage() . "\n";
    // الخروج مع رمز خطأ
    exit(1);
}
?>
