<?php
// ==================================================================
// register.php - v6 - الإصلاح النهائي لدالة execute
// ==================================================================

header('Content-Type: application/json');
require_once 'db_connect.php';

// أزل هذه الأسطر عند الانتقال إلى الإنتاج
ini_set('display_errors', 1);
error_reporting(E_ALL);

try {
    if (!isset($conn)) {
        throw new Exception("فشل الاتصال بقاعدة البيانات.");
    }

    $data = json_decode(file_get_contents('php://input'), true);

    $display_name = trim($data['display_name'] ?? '');
    $username = trim($data['username'] ?? '');
    $email = trim($data['email'] ?? '');
    $password = $data['password'] ?? '';

    // 1. التحقق من صحة المدخلات
    if (empty($display_name) || empty($username) || empty($email) || empty($password)) {
        throw new Exception("الرجاء ملء جميع الحقول.");
    }
    // ... (بقية التحققات)

    // 2. التحقق من أن اسم المستخدم أو البريد الإلكتروني غير مستخدم
    $stmt = $conn->prepare("SELECT id FROM users WHERE username = :username OR email = :email");
    $stmt->execute([':username' => $username, ':email' => $email]);
    if ($stmt->fetch()) {
        throw new Exception("اسم المستخدم أو البريد الإلكتروني مستخدم بالفعل.");
    }

    // 3. تشفير كلمة المرور
    $password_hash = password_hash($password, PASSWORD_BCRYPT);

    // 4. إنشاء كود دعوة فريد
    $invitation_code = '';
    do {
        $invitation_code = substr(str_shuffle('ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'), 0, 6);
        $stmt_check_code = $conn->prepare("SELECT id FROM users WHERE invitation_code = :code");
        $stmt_check_code->execute([':code' => $invitation_code]);
    } while ($stmt_check_code->fetch());

    // ★★★★★   بداية التعديل النهائي هنا   ★★★★★
    // 5. إدخال المستخدم الجديد مع تحديد كل الأعمدة المطلوبة
    $stmt_insert = $conn->prepare(
        "INSERT INTO users (display_name, username, email, password_hash, invitation_code, auth_type, profile_image_url) 
         VALUES (:display_name, :username, :email, :password_hash, :invitation_code, :auth_type, NULL)"
    );
    
    // تم تصحيح دالة execute لتمرير كل المتغيرات المطلوبة
    $stmt_insert->execute([
        ':display_name' => $display_name,
        ':username' => $username,
        ':email' => $email,
        ':password_hash' => $password_hash,
        ':invitation_code' => $invitation_code,
        ':auth_type' => 'email' // تمرير القيمة هنا
    ]);
    // ★★★★★    نهاية التعديل النهائي هنا    ★★★★★

    $user_id = $conn->lastInsertId();

    // 6. جلب بيانات المستخدم الجديد لإرسالها كرد
    $stmt_new = $conn->prepare("SELECT * FROM users WHERE id = :id");
    $stmt_new->execute([':id' => $user_id]);
    $new_user = $stmt_new->fetch(PDO::FETCH_ASSOC);
    unset($new_user['password_hash']);

    http_response_code(201 );
    echo json_encode([
        'status' => 'success',
        'message' => 'تم إنشاء الحساب بنجاح.',
        'data' => $new_user
    ]);

} catch (Throwable $e) {
    http_response_code(500 );
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage()
    ]);
}

exit();
?>
