<?php
header('Content-Type: application/json; charset=utf-8');
require 'db_connect.php';

$data = json_decode(file_get_contents('php://input'), true);

$visitor_id = isset($data['visitor_id']) ? intval($data['visitor_id']) : 0;
$visited_id = isset($data['visited_id']) ? intval($data['visited_id']) : 0;

if ($visitor_id <= 0 || $visited_id <= 0) {
    http_response_code(400);
    exit(json_encode([
        'status'  => 'error',
        'message' => 'Visitor ID and Visited ID are required.'
    ]));
}

if ($visitor_id === $visited_id) {
    exit(json_encode([
        'status'  => 'info',
        'message' => 'Cannot visit own profile.'
    ]));
}

try {
    // الحل: INSERT ON DUPLICATE KEY UPDATE
    // اذا كان السجل موجوداً (بسبب UNIQUE KEY) يُحدَّث الوقت فقط
    // اذا لم يكن موجوداً يُدرج سجل جديد
    $stmt = $conn->prepare(
        "INSERT INTO profile_visits (visitor_id, visited_id, visit_timestamp)
         VALUES (:visitor_id, :visited_id, CURRENT_TIMESTAMP)
         ON DUPLICATE KEY UPDATE visit_timestamp = CURRENT_TIMESTAMP"
    );

    $stmt->execute([
        ':visitor_id' => $visitor_id,
        ':visited_id' => $visited_id
    ]);

    // rowCount() = 1 يعني INSERT جديد، = 2 يعني UPDATE
    $affected = $stmt->rowCount();
    $action   = ($affected == 1) ? 'inserted' : 'updated';

    echo json_encode([
        'status'  => 'success',
        'message' => 'Visit recorded',
        'action'  => $action
    ]);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'status'  => 'error',
        'message' => 'Database error: ' . $e->getMessage()
    ]);
}
?>