<?php
header('Content-Type: application/json; charset=utf-8');
error_reporting(0);
ini_set('display_errors', 0);

require_once __DIR__ . '/db_connect.php';

$log_file = __DIR__ . '/pusher_auth_debug.log';

function logMessage($message) {
    global $log_file;
    file_put_contents($log_file,
        date('Y-m-d H:i:s') . " - " . $message . "\n",
        FILE_APPEND
    );
}

function pusher_presence_auth($channel, $socket_id, $user_id, $user_info, $key, $secret) {
    $user_data       = json_encode($user_info);
    $string_to_sign  = $socket_id . ':' . $channel . ':' . $user_data;
    $auth_signature  = hash_hmac('sha256', $string_to_sign, $secret);
    return json_encode([
        'auth'         => $key . ':' . $auth_signature,
        'channel_data' => $user_data
    ]);
}

try {
    logMessage("=== New Auth Request ===");

    $post_data = $_POST;
    if (empty($post_data)) {
        $raw_post = file_get_contents('php://input');
        if (!empty($raw_post)) {
            parse_str($raw_post, $post_data);
        }
    }

    $socket_id    = $post_data['socket_id']    ?? '';
    $channel_name = $post_data['channel_name'] ?? '';
    $user_id      = (int)($post_data['user_id'] ?? $_GET['user_id'] ?? $_SERVER['HTTP_X_USER_ID'] ?? 0);

    logMessage("Socket: $socket_id, Channel: $channel_name, User: $user_id");

    if (empty($socket_id) || empty($channel_name) || $user_id <= 0) {
        http_response_code(400);
        die(json_encode(['status' => 'error', 'message' => 'بيانات المصادقة غير مكتملة']));
    }

    if (strpos($channel_name, 'presence-room-') !== 0) {
        http_response_code(403);
        die(json_encode(['status' => 'error', 'message' => 'قناة غير صالحة']));
    }

    $room_id = (int)str_replace('presence-room-', '', $channel_name);

    // التحقق من العضوية وجلب الدور
    $stmt_member = $conn->prepare("SELECT role FROM room_members WHERE room_id = :room_id AND user_id = :user_id");
    $stmt_member->execute([':room_id' => $room_id, ':user_id' => $user_id]);
    $member = $stmt_member->fetch(PDO::FETCH_ASSOC);

    if (!$member) {
        logMessage("User $user_id not member of room $room_id");
        http_response_code(403);
        die(json_encode(['status' => 'error', 'message' => 'غير مصرح بالوصول']));
    }

    // تحديث حالة الاتصال
    $stmt_update = $conn->prepare("UPDATE room_members SET is_online = 1 WHERE room_id = :room_id AND user_id = :user_id");
    $stmt_update->execute([':room_id' => $room_id, ':user_id' => $user_id]);
    logMessage("Updated is_online = 1 for user $user_id in room $room_id");

    // ★ جلب معلومات المستخدم مع بيانات VIP
    $stmt_user = $conn->prepare("
        SELECT display_name, level, profile_image_url, frame_identifier,
               name_color, font_identifier, is_verified,
               vip_tier, vip_expires_at, vip_gif_url
        FROM users WHERE id = :user_id
    ");
    $stmt_user->execute([':user_id' => $user_id]);
    $user = $stmt_user->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        logMessage("User $user_id not found in database");
        http_response_code(403);
        die(json_encode(['status' => 'error', 'message' => 'مستخدم غير موجود']));
    }

    // ★ حساب VIP
    $now         = time();
    $vipTier     = $user['vip_tier']      ?? 'none';
    $vipExpires  = $user['vip_expires_at'];
    $vipIsActive = ($vipTier !== 'none')
        && ($vipExpires === null || strtotime($vipExpires) > $now);

    $vipTierFinal = $vipIsActive ? $vipTier : 'none';
    $vipGifUrl    = ($vipIsActive && $vipTier === 'gold' && !empty($user['vip_gif_url']))
                        ? $user['vip_gif_url']
                        : null;

    // ★ إعداد معلومات المستخدم مع بيانات VIP
    $user_info = [
        'user_id'          => $user_id,
        'display_name'     => $user['display_name']      ?? '',
        'image_url'        => $user['profile_image_url'] ?? '',
        'level'            => (int)($user['level']       ?? 1),
        'frame_identifier' => $user['frame_identifier']  ?? '',
        'name_color'       => $user['name_color']        ?? '',
        'font_identifier'  => $user['font_identifier']   ?? '',
        'is_verified'      => (int)($user['is_verified'] ?? 0),
        'role'             => $member['role']             ?? 'member',
        // ★ VIP
        'vip_tier'         => $vipTierFinal,
        'vip_is_active'    => $vipIsActive,
        'vip_gif_url'      => $vipGifUrl,
    ];

    logMessage("User role: " . $user_info['role'] . ", VIP: " . $vipTierFinal);

    $pusher_key    = "c0a2fe3c47f0775d0be1";
    $pusher_secret = "85330156aec9dd641145";

    $auth_response = pusher_presence_auth(
        $channel_name,
        $socket_id,
        (string)$user_id,
        $user_info,
        $pusher_key,
        $pusher_secret
    );

    logMessage("Auth SUCCESS for user $user_id");
    logMessage("Response: $auth_response");

    echo $auth_response;

} catch (PDOException $e) {
    logMessage("DATABASE ERROR: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'خطأ في قاعدة البيانات']);
} catch (Exception $e) {
    logMessage("EXCEPTION: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'خطأ في الخادم']);
}
?>