<?php
header('Content-Type: application/json; charset=utf-8');
require 'db_connect.php';

$pusher_available = false;
if (file_exists(__DIR__ . '/PusherHelper.php')) {
    try {
        require_once __DIR__ . '/PusherHelper.php';
        $pusher_available = function_exists('send_pusher_trigger');
    } catch (Exception $e) {
        error_log("PusherHelper error: " . $e->getMessage());
    }
}

$data = json_decode(file_get_contents('php://input'), true);
$ownerId = isset($data['owner_id']) ? (int)$data['owner_id'] : 0;
$targetId = isset($data['target_id']) ? (int)$data['target_id'] : 0;
$roomId = isset($data['room_id']) ? (int)$data['room_id'] : 0;

if ($ownerId <= 0 || $targetId <= 0 || $roomId <= 0) {
    http_response_code(400);
    die(json_encode(['status' => 'error', 'message' => 'بيانات غير مكتملة']));
}

try {
    $conn->beginTransaction();
    
    $stmt_owner = $conn->prepare("SELECT role FROM room_members WHERE room_id = :room_id AND user_id = :user_id");
    $stmt_owner->execute([':room_id' => $roomId, ':user_id' => $ownerId]);
    $owner = $stmt_owner->fetch();
    
    if (!$owner || $owner['role'] !== 'owner') {
        throw new Exception("غير مصرح");
    }
    
    $stmt_target = $conn->prepare("SELECT role FROM room_members WHERE room_id = :room_id AND user_id = :user_id");
    $stmt_target->execute([':room_id' => $roomId, ':user_id' => $targetId]);
    $target = $stmt_target->fetch();
    
    if (!$target) {
        throw new Exception("المستخدم ليس عضواً");
    }
    
    if ($target['role'] !== 'member') {
        throw new Exception("المستخدم مشرف بالفعل");
    }
    
    // ✅✅ ترقية المستخدم إلى admin
    $stmt_update = $conn->prepare("UPDATE room_members SET role = 'admin' WHERE room_id = :room_id AND user_id = :user_id");
    $stmt_update->execute([':room_id' => $roomId, ':user_id' => $targetId]);
    
    // ✅ جلب بيانات المستخدم لإرسال رسالة نظام
    $stmt_user = $conn->prepare("SELECT display_name, level, profile_image_url, frame_identifier, name_color, font_identifier, is_verified FROM users WHERE id = :user_id");
    $stmt_user->execute([':user_id' => $targetId]);
    $user = $stmt_user->fetch(PDO::FETCH_ASSOC);
    $userName = $user ? $user['display_name'] : 'مستخدم';
    
    // ✅ إضافة رسالة نظام
    $systemMessage = "$userName تمت ترقيته إلى مشرف";
    $stmt_msg = $conn->prepare("INSERT INTO room_messages (room_id, user_id, message_text, is_system) VALUES (?, ?, ?, 1)");
    $stmt_msg->execute([$roomId, $targetId, $systemMessage]);
    $messageId = $conn->lastInsertId();
    
    // ✅ إرسال إشعار Pusher
    if ($pusher_available) {
        try {
            // إشعار للمستخدم المُرقى
            send_pusher_trigger(
                "c0a2fe3c47f0775d0be1",
                "85330156aec9dd641145",
                "2109257",
                "mt1",
                'user-' . $targetId,
                'role-updated',
                [
                    'room_id' => $roomId,
                    'new_role' => 'admin'
                ]
            );
            
            // رسالة النظام للغرفة
            if ($user) {
                send_pusher_trigger(
                    "c0a2fe3c47f0775d0be1",
                    "85330156aec9dd641145",
                    "2109257",
                    "mt1",
                    'presence-room-' . $roomId,
                    'new-message',
                    [
                        'id' => (int)$messageId,
                        'room_id' => $roomId,
                        'user_id' => $targetId,
                        'user_name' => $userName,
                        'user_level' => (int)$user['level'],
                        'user_image_url' => $user['profile_image_url'],
                        'frame_identifier' => $user['frame_identifier'],
                        'name_color' => $user['name_color'],
                        'font_identifier' => $user['font_identifier'],
                        'is_verified' => (int)$user['is_verified'],
                        'message_text' => $systemMessage,
                        'is_system' => true,
                        'created_at' => date('Y-m-d H:i:s')
                    ]
                );
            }
        } catch (Exception $e) {
            error_log("Pusher failed: " . $e->getMessage());
        }
    }
    
    $conn->commit();
    echo json_encode(['status' => 'success', 'message' => 'تمت الترقية']);
} catch (Exception $e) {
    if ($conn->inTransaction()) $conn->rollBack();
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>