<?php
// mark_messages_as_read.php

header('Content-Type: application/json; charset=utf-8');
require 'db_connect.php';

$data = json_decode(file_get_contents('php://input'), true);

$userId = $data['user_id'] ?? 0;
$partnerId = $data['partner_id'] ?? 0;

if (empty($userId) || empty($partnerId)) {
    http_response_code(400 );
    exit(json_encode(['status' => 'error', 'message' => 'معرفات المستخدمين مطلوبة.']));
}

try {
    $stmt = $conn->prepare(
        "UPDATE messages 
         SET is_read = 1 
         WHERE recipient_id = :user_id 
           AND sender_id = :partner_id 
           AND is_read = 0"
    );

    $stmt->execute([
        ':user_id' => $userId,
        ':partner_id' => $partnerId
    ]);

    // لا يهمنا عدد الصفوف التي تأثرت، المهم أن العملية تمت
    echo json_encode([
        'status' => 'success',
        'message' => 'تم تحديث الرسائل كمقروءة.'
    ]);

} catch (Exception $e) {
    http_response_code(500 );
    error_log("Mark As Read Error: " . $e->getMessage());
    echo json_encode(['status' => 'error', 'message' => 'حدث خطأ في الخادم.']);
}
?>
