<?php
// login_with_google.php - (v7) محسّن - يحافظ على الصورة المخصصة + صورة VIP المتحركة

header('Content-Type: application/json; charset=utf-8');

ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/vendor/autoload.php';
require_once 'db_connect.php';

$web_client_id = '1054187523005-546f7h42884h8kc3jvbfu76c8h9mprt1.apps.googleusercontent.com';

$data = json_decode(file_get_contents('php://input'), true);
$id_token = $data['id_token'] ?? null;

if (!$id_token) {
    http_response_code(400);
    exit(json_encode(['status' => 'error', 'message' => 'ID token is missing.']));
}

try {
    if (!isset($conn)) {
        throw new Exception("Database connection failed.");
    }

    $client = new Google_Client(['client_id' => $web_client_id]);
    $payload = $client->verifyIdToken($id_token);

    if (!$payload) {
        http_response_code(401);
        throw new Exception("Invalid ID token.");
    }

    $google_id            = $payload['sub'];
    $email                = $payload['email'] ?? null;
    $display_name         = $payload['name'] ?? 'User';
    $google_profile_image = $payload['picture'] ?? null;

    // ★★★ التحقق من وجود المستخدم ★★★
    $stmt = $conn->prepare("SELECT id FROM users WHERE google_id = :google_id");
    $stmt->execute([':google_id' => $google_id]);
    $existing_user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($existing_user) {
        // ★★★ المستخدم موجود — جلب كل البيانات الحالية ★★★
        $user_id = $existing_user['id'];

        $stmt = $conn->prepare("
            SELECT profile_image_url, display_name, username, vip_gif_url
            FROM users WHERE id = :id
        ");
        $stmt->execute([':id' => $user_id]);
        $currentData = $stmt->fetch(PDO::FETCH_ASSOC);

        $current_image_url    = $currentData['profile_image_url'];
        $current_display_name = $currentData['display_name'];
        $current_username     = $currentData['username'];
        $current_vip_gif_url  = $currentData['vip_gif_url']; // ★ الصورة المتحركة

        // ★ فحص 1: هل الصورة من Google أم مخصصة؟
        $is_google_image = (
            $current_image_url === null ||
            $current_image_url === '' ||
            strpos($current_image_url, 'googleusercontent.com') !== false ||
            strpos($current_image_url, 'lh3.google') !== false
        );

        // ★ فحص 2: هل الاسم من Google أم معدّل؟
        $is_google_display_name = (
            $current_display_name === null ||
            $current_display_name === '' ||
            $current_display_name === 'User' ||
            $current_display_name === $display_name ||
            strtolower($current_display_name) === strtolower($display_name)
        );

        // ★ فحص 3: هل اسم المستخدم من Google أم معدّل؟
        $is_google_username = (
            $current_username === null ||
            preg_match('/^[a-z]+\d{3}$/', $current_username) === 1
        );

        // ★★★ بناء استعلام التحديث ★★★
        $update_fields = [];
        $update_params = [':id' => $user_id, ':email' => $email];

        // Email دائماً
        $update_fields[] = "email = :email";

        // الصورة العادية — فقط إذا كانت من Google
        if ($is_google_image) {
            $update_fields[] = "profile_image_url = :profile_image_url";
            $update_params[':profile_image_url'] = $google_profile_image;
            error_log("🖼️ Updating Google image");
        } else {
            error_log("🖼️ Keeping custom image: $current_image_url");
        }

        // ★★★ vip_gif_url — لا تلمسه أبداً عند تسجيل الدخول ★★★
        // الصورة المتحركة يرفعها المستخدم يدوياً ولا علاقة لها بـ Google
        if (!empty($current_vip_gif_url)) {
            error_log("🎬 Preserving vip_gif_url: $current_vip_gif_url");
        }

        // display_name — فقط إذا كان من Google
        if ($is_google_display_name) {
            $update_fields[] = "display_name = :display_name";
            $update_params[':display_name'] = $display_name;
            error_log("👤 Updating Google display name");
        } else {
            error_log("👤 Keeping custom display name: $current_display_name");
        }

        // username — فقط إذا كان من Google
        if ($is_google_username) {
            $new_username = strtolower(str_replace(' ', '', $display_name)) . rand(100, 999);
            $update_fields[] = "username = :username";
            $update_params[':username'] = $new_username;
            error_log("📛 Updating Google username");
        } else {
            error_log("📛 Keeping custom username: $current_username");
        }

        // تنفيذ التحديث
        if (!empty($update_fields)) {
            $update_sql = "UPDATE users SET " . implode(", ", $update_fields) . " WHERE id = :id";
            $updateStmt = $conn->prepare($update_sql);
            $updateStmt->execute($update_params);
            error_log("✅ Updated Google user ID: $user_id");
        }

    } else {
        // ★★★ مستخدم جديد — إنشاء حساب ★★★
        $username = strtolower(str_replace(' ', '', $display_name)) . rand(100, 999);

        // توليد كود دعوة فريد
        $invitation_code = '';
        do {
            $invitation_code = substr(str_shuffle('ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'), 0, 6);
            $stmt_check = $conn->prepare("SELECT id FROM users WHERE invitation_code = :code");
            $stmt_check->execute([':code' => $invitation_code]);
        } while ($stmt_check->fetch());

        $insertStmt = $conn->prepare("
            INSERT INTO users 
                (google_id, email, display_name, username, profile_image_url, auth_type, invitation_code) 
            VALUES 
                (:google_id, :email, :display_name, :username, :profile_image_url, 'google', :invitation_code)
        ");
        $insertStmt->execute([
            ':google_id'         => $google_id,
            ':email'             => $email,
            ':display_name'      => $display_name,
            ':username'          => $username,
            ':profile_image_url' => $google_profile_image,
            ':invitation_code'   => $invitation_code,
        ]);

        $user_id = $conn->lastInsertId();
        error_log("✅ Created new Google user ID: $user_id");
    }

    // ★★★ جلب البيانات الكاملة للـ response ★★★
    $stmt = $conn->prepare("
        SELECT 
            id,
            username,
            display_name,
            email,
            invitation_code,
            profile_image_url,
            vip_gif_url,
            auth_type,
            name_color,
            font_identifier,
            frame_identifier,
            is_verified
        FROM users
        WHERE id = :id
    ");
    $stmt->execute([':id' => $user_id]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        throw new Exception("Failed to retrieve user data after login.");
    }

    $user['is_verified'] = (bool)$user['is_verified'];

    error_log("📤 Response - image: " . $user['profile_image_url'] . " | gif: " . $user['vip_gif_url']);

    http_response_code(200);
    echo json_encode([
        'status'  => 'success',
        'message' => 'Login successful.',
        'data'    => $user
    ]);

} catch (Throwable $e) {
    http_response_code(500);
    error_log('❌ Google Login Error: ' . $e->getMessage() . ' in ' . $e->getFile() . ':' . $e->getLine());
    echo json_encode([
        'status'  => 'error',
        'message' => 'An internal server error occurred.',
        'debug'   => $e->getMessage() // احذف في Production
    ]);
}

exit();
?>