<?php
// ==================================================================
// login.php - (v3) مع بيانات الإطار والتوثيق
// ==================================================================
ini_set('display_errors', 1);
error_reporting(E_ALL);

header('Content-Type: application/json; charset=utf-8');
require_once 'db_connect.php';

try {
    if (!isset($conn)) {
        throw new Exception("فشل الاتصال بقاعدة البيانات.");
    }

    $data = json_decode(file_get_contents('php://input'), true);
    $email = $data['email'] ?? null;
    $password = $data['password'] ?? null;

    if (empty($email) || empty($password)) {
        http_response_code(400 ); // Bad Request
        throw new Exception("الرجاء إدخال البريد الإلكتروني وكلمة المرور.");
    }

    // ★★★★★   بداية التعديل: إضافة حقلي الإطار والتوثيق   ★★★★★
    $stmt = $conn->prepare(
        "SELECT 
            id, 
            username, 
            display_name, 
            email,
            password_hash, 
            invitation_code,
            profile_image_url,
            auth_type,
            name_color,
            font_identifier,
            frame_identifier,
            is_verified
         FROM users 
         WHERE email = :email"
    );
    // ★★★★★    نهاية التعديل    ★★★★★

    $stmt->execute([':email' => $email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        http_response_code(401 ); // Unauthorized
        throw new Exception("البريد الإلكتروني أو كلمة المرور غير صحيحة.");
    }

    if (password_verify($password, $user['password_hash'])) {
        unset($user['password_hash']);
        
        // تحويل قيمة is_verified إلى boolean لتسهيل التعامل معها في التطبيق
        $user['is_verified'] = (bool)$user['is_verified'];

        echo json_encode([
            'status' => 'success',
            'message' => 'تم تسجيل الدخول بنجاح.',
            'data' => $user // تم تغيير المفتاح إلى 'data' ليتوافق مع بقية الملفات
        ]);

    } else {
        http_response_code(401 ); // Unauthorized
        throw new Exception("البريد الإلكتروني أو كلمة المرور غير صحيحة.");
    }

} catch (Throwable $e) {
    $statusCode = $e->getCode() ?: 500;
    http_response_code($statusCode );
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage()
    ]);
}

exit();
?>
