<?php
// link_account.php (v4 - يدعم الإشعار اللحظي عبر Pusher)

header('Content-Type: application/json; charset=utf-8');

// استدعاء ملف المساعدة الذي يحتوي على دالة إرسال طلبات Pusher
require_once __DIR__ . '/PusherHelper.php'; 

require 'db_connect.php';

// إعدادات تسجيل الأخطاء
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', 'php-errors.log');
error_reporting(E_ALL);

$data = json_decode(file_get_contents('php://input'), true);

$requesterId = $data['user_id_b'] ?? 0;
$identifier = $data['invitation_code'] ?? ''; // قد يكون كود دعوة أو ID

if (empty($requesterId) || empty($identifier)) {
    http_response_code(400 );
    exit(json_encode(['status' => 'error', 'message' => 'معرف المستخدم والبيانات التعريفية للشريك مطلوبة.']));
}

try {
    // --- الجزء الأول: البحث عن المستخدم المستقبل (Recipient) ---
    $recipient = null;
    if (is_numeric($identifier)) {
        $stmt_recipient = $conn->prepare("SELECT id, fcm_token FROM users WHERE id = :id AND couple_id IS NULL");
        $stmt_recipient->execute([':id' => $identifier]);
        $recipient = $stmt_recipient->fetch(PDO::FETCH_ASSOC);
    } else {
        $stmt_recipient = $conn->prepare("SELECT id, fcm_token FROM users WHERE invitation_code = :code AND couple_id IS NULL");
        $stmt_recipient->execute([':code' => $identifier]);
        $recipient = $stmt_recipient->fetch(PDO::FETCH_ASSOC);
    }

    if (!$recipient) {
        throw new Exception("البيانات التعريفية للشريك غير صالحة أو أن المستخدم مرتبط بالفعل.");
    }
    
    $recipientId = (int)$recipient['id'];
    $recipientToken = $recipient['fcm_token'];

    // --- الجزء الثاني: التحقق من الشروط وإنشاء الطلب ---

    if ($recipientId === (int)$requesterId) {
        throw new Exception("لا يمكنك إرسال طلب ارتباط لنفسك.");
    }
    
    // جلب بيانات المرسل (اسمه وحالته)
    $stmt_requester = $conn->prepare("SELECT display_name, couple_id FROM users WHERE id = :requesterId");
    $stmt_requester->execute([':requesterId' => $requesterId]);
    $requesterUser = $stmt_requester->fetch(PDO::FETCH_ASSOC);
    
    if (!$requesterUser) {
        throw new Exception("بيانات مرسل الطلب غير موجودة.");
    }
    if ($requesterUser['couple_id'] !== null) {
        throw new Exception("لا يمكنك إرسال طلب وأنت مرتبط بالفعل.");
    }
    $requesterName = $requesterUser['display_name'];

    // إدراج طلب جديد في جدول connection_requests
    $stmt_insert_request = $conn->prepare(
        "INSERT INTO connection_requests (requester_id, recipient_id, status) 
         VALUES (:requesterId, :recipientId, 'pending')"
    );
    $stmt_insert_request->execute([':requesterId' => $requesterId, ':recipientId' => $recipientId]);

    // ★★★★★   بداية منطقة Pusher   ★★★★★
    // إرسال إشعار لحظي داخل التطبيق للمستلم
    $recipient_channel = 'user-' . $recipientId;
    $event_name = 'incoming-request';
    $pusher_data = [
        'requester_name' => $requesterName,
        'message' => "أرسل لك " . $requesterName . " طلب ارتباط جديد!"
    ];
    send_pusher_trigger("c0a2fe3c47f0775d0be1", "85330156aec9dd641145", "2109257", "mt1", $recipient_channel, $event_name, $pusher_data);
    // ★★★★★    نهاية منطقة Pusher    ★★★★★

    // إرسال رد ناجح مع توكن المستقبل (لإشعار FCM الخارجي)
    echo json_encode([
        'status' => 'success', 
        'message' => 'تم إرسال طلب الارتباط بنجاح!',
        'data' => [
            'partner_token' => $recipientToken
        ]
    ]);

} catch (PDOException $e) {
    if ($e->errorInfo[1] == 1062) {
        http_response_code(409 );
        echo json_encode(['status' => 'error', 'message' => 'لقد أرسلت طلباً لهذا المستخدم بالفعل.']);
    } else {
        http_response_code(500 );
        echo json_encode(['status' => 'error', 'message' => 'خطأ في قاعدة البيانات: ' . $e->getMessage()]);
    }
} catch (Exception $e) {
    http_response_code(400 );
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}

$conn = null;
?>
