<?php
header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL);
ini_set('display_errors', 1);
require_once 'db_connect.php';

$pusher_available = false;
if (file_exists(__DIR__ . '/PusherHelper.php')) {
    try {
        require_once __DIR__ . '/PusherHelper.php';
        $pusher_available = function_exists('send_pusher_trigger');
    } catch (Exception $e) {
        error_log("PusherHelper error: " . $e->getMessage());
    }
}

$data = json_decode(file_get_contents('php://input'), true) ?: [];
$userId = isset($data['user_id']) ? (int)$data['user_id'] : 0;
$roomId = isset($data['room_id']) ? (int)$data['room_id'] : 0;

if ($userId <= 0 || $roomId <= 0) {
    http_response_code(400);
    die(json_encode(['status' => 'error', 'message' => 'بيانات غير مكتملة']));
}

try {
    $stmtUser = $conn->prepare("SELECT display_name, level, profile_image_url, frame_identifier, name_color, font_identifier, is_verified FROM users WHERE id = :user_id");
    $stmtUser->execute([':user_id' => $userId]);
    $user = $stmtUser->fetch(PDO::FETCH_ASSOC);
    $userName = $user ? $user['display_name'] : 'مستخدم';

    // ✅✅ تحديث الحالة بدلاً من الحذف
    $stmt = $conn->prepare("UPDATE room_members SET is_online = 0 WHERE room_id = :room_id AND user_id = :user_id");
    $stmt->execute([':room_id' => $roomId, ':user_id' => $userId]);
    
    if ($stmt->rowCount() > 0) {
        $systemMessage = "$userName غادر الغرفة";
        
        $stmt_msg = $conn->prepare("INSERT INTO room_messages (room_id, user_id, message_text, is_system) VALUES (?, ?, ?, 1)");
        $stmt_msg->execute([$roomId, $userId, $systemMessage]);
        $messageId = $conn->lastInsertId();
        
        if ($pusher_available && $user) {
            try {
                send_pusher_trigger(
                    "c0a2fe3c47f0775d0be1",
                    "85330156aec9dd641145",
                    "2109257",
                    "mt1",
                    'presence-room-' . $roomId,
                    'new-message',
                    [
                        'id' => (int)$messageId,
                        'room_id' => $roomId,
                        'user_id' => $userId,
                        'user_name' => $userName,
                        'user_level' => (int)$user['level'],
                        'user_image_url' => $user['profile_image_url'],
                        'frame_identifier' => $user['frame_identifier'],
                        'name_color' => $user['name_color'],
                        'font_identifier' => $user['font_identifier'],
                        'is_verified' => (int)$user['is_verified'],
                        'message_text' => $systemMessage,
                        'is_system' => true,
                        'created_at' => date('Y-m-d H:i:s')
                    ]
                );
            } catch (Exception $e) {
                error_log("Pusher failed in leave_room: " . $e->getMessage());
            }
        }
        
        echo json_encode(['status' => 'success', 'message' => 'تمت المغادرة بنجاح']);
    } else {
        echo json_encode(['status' => 'ignored', 'message' => 'المستخدم لم يكن عضواً في الغرفة']);
    }
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'خطأ في الخادم: ' . $e->getMessage()]);
}
?>