<?php
/**
 * grant_reward.php - النسخة المحدثة مع نظام الحدود اليومية
 * =========================================================
 * منح المكافأة للمستخدم مع دعم الحدود اليومية
 * 
 * @version 3.0
 * @date 2026-02-05
 */
header('Content-Type: application/json; charset=utf-8');
require 'db_connect.php';

$rewardsEnabled = false;
$useNewRewardSystem = false;

if (file_exists('points_manager_v2.php')) {
    try {
        require 'points_manager_v2.php';
        $useNewRewardSystem = function_exists('grantRewardV2');
        $rewardsEnabled = true;
    } catch (Exception $e) {
        error_log("Failed to load points_manager_v2.php: " . $e->getMessage());
    }
}

if (!$rewardsEnabled && file_exists('points_manager.php')) {
    try {
        require 'points_manager.php';
        $rewardsEnabled = function_exists('grantReward');
    } catch (Exception $e) {
        error_log("Failed to load points_manager.php: " . $e->getMessage());
    }
}

if (!$rewardsEnabled) {
    http_response_code(500);
    exit(json_encode([
        'status' => 'error',
        'message' => 'نظام المكافآت غير متاح حالياً.'
    ]));
}

$data = json_decode(file_get_contents('php://input'), true);
$user_id = $data['user_id'] ?? 0;
$reward_type = $data['reward_type'] ?? '';

if (empty($user_id) || empty($reward_type)) {
    http_response_code(400);
    exit(json_encode([
        'status' => 'error',
        'message' => 'بيانات الطلب غير مكتملة.'
    ]));
}

try {
    if ($useNewRewardSystem) {
        $result = grantRewardV2($conn, $user_id, $reward_type);
        
        if ($result['status'] === 'success') {
            echo json_encode([
                'status' => 'success',
                'data' => $result
            ]);
        } elseif ($result['status'] === 'limit_reached') {
            http_response_code(429);
            echo json_encode([
                'status' => 'limit_reached',
                'data' => $result
            ]);
        } else {
            throw new Exception($result['message']);
        }
        
    } else {
        $result = grantReward($conn, $user_id, $reward_type);
        
        if ($result['status'] === 'success') {
            echo json_encode([
                'status' => 'success',
                'data' => $result
            ]);
        } else {
            throw new Exception($result['message']);
        }
    }
} catch (Exception $e) {
    http_response_code(500);
    error_log("Reward Error: " . $e->getMessage());
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage()
    ]);
}
?>