<?php
/**
 * get_users.php — معدّل لنظام VIP
 * =================================
 * التعديل: إضافة vip_tier و vip_is_active و vip_gif_url لكل مستخدم
 */
header('Content-Type: application/json; charset=utf-8');
require 'db_connect.php';

$data            = json_decode(file_get_contents('php://input'), true);
$current_user_id = $data['user_id']       ?? 0;
$search_query    = trim($data['search_query'] ?? '');

if (empty($current_user_id)) {
    http_response_code(400);
    exit(json_encode(['status' => 'error', 'message' => 'User ID is required.']));
}

try {
    $params = [];
    $sql = "
        SELECT
            u.id,
            u.display_name,
            u.username,
            u.profile_image_url,
            u.bio,
            u.name_color,
            u.font_identifier,
            u.frame_identifier,
            u.is_verified,
            u.couple_id,
            u.level,
            u.xp,
            u.vip_tier,
            u.vip_expires_at,
            u.vip_gif_url,
            p.id                AS partner_id,
            p.display_name      AS partner_display_name,
            p.profile_image_url AS partner_profile_image_url
        FROM users u
        LEFT JOIN couples c ON u.couple_id = c.id
        LEFT JOIN users p ON (c.user1_id = p.id OR c.user2_id = p.id) AND p.id != u.id
    ";

    if (!empty($search_query)) {
        $sql .= " WHERE (u.display_name LIKE :search_query OR u.username LIKE :search_query)";
        $params[':search_query'] = '%' . $search_query . '%';
    } else {
        $sql .= " ORDER BY RAND() LIMIT 50";
    }

    $stmt = $conn->prepare($sql);
    $stmt->execute($params);
    $users = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $now = time();
    $users = array_map(function($user) use ($now) {
        $user['is_verified'] = (bool)$user['is_verified'];
        $user['level']       = (int)($user['level'] ?? 1);
        $user['xp']          = (int)($user['xp']    ?? 0);

        // ★ حساب VIP
        $vipTier     = $user['vip_tier'] ?? 'none';
        $vipExpires  = $user['vip_expires_at'];
        $vipIsActive = ($vipTier !== 'none')
            && ($vipExpires === null || strtotime($vipExpires) > $now);

        $user['vip_tier']      = $vipIsActive ? $vipTier : 'none';
        $user['vip_is_active'] = $vipIsActive;

        // ★ إرسال vip_gif_url للمستخدم الذهبي فقط
        $user['vip_gif_url'] = ($vipIsActive && $vipTier === 'gold' && !empty($user['vip_gif_url']))
            ? $user['vip_gif_url']
            : null;

        unset($user['vip_expires_at']);

        if ($user['couple_id'] === null) {
            $user['partner_id']                = null;
            $user['partner_display_name']      = null;
            $user['partner_profile_image_url'] = null;
        }

        return $user;
    }, $users);

    echo json_encode(['status' => 'success', 'data' => $users]);

} catch (Exception $e) {
    http_response_code(500);
    error_log('Get Users Error: ' . $e->getMessage());
    echo json_encode(['status' => 'error', 'message' => 'حدث خطأ في الخادم أثناء جلب المستخدمين.']);
}
?>