<?php
// get_user_status.php
header('Content-Type: application/json; charset=utf-8');
require_once 'db_connect.php';

try {
    $user_id = isset($_GET['user_id']) ? intval($_GET['user_id']) : 0;
    if ($user_id <= 0) {
        echo json_encode(['status' => 'error', 'message' => 'user_id مطلوب']);
        exit;
    }

    $stmt = $conn->prepare("SELECT is_active, last_active FROM users WHERE id = ? LIMIT 1");
    $stmt->execute([$user_id]);
    $row = $stmt->fetch();

    if (!$row) {
        echo json_encode(['status' => 'error', 'message' => 'المستخدم غير موجود']);
        exit;
    }

    $is_active   = 0;
    $diff_seconds = null;

    if ($row['last_active']) {
        $last         = strtotime($row['last_active']);
        $now          = time();
        $diff_seconds = $now - $last;

        // متصل إذا آخر نشاط خلال 30 ثانية
        $is_active = ($diff_seconds <= 30) ? 1 : 0;
    }

    echo json_encode([
        'status'       => 'success',
        'is_active'    => $is_active,
        'last_active'  => $row['last_active'],
        'diff_seconds' => $diff_seconds,   // ✅ الفرق بالثواني للتطبيق
    ]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>