<?php
/**
 * get_user_info.php — معدّل لنظام VIP
 * =====================================
 * يُستخدم في الغرف — أضفنا vip_tier و vip_is_active و vip_frame_url
 */
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__ . '/db_connect.php';

$user_id = isset($_GET['user_id']) ? (int)$_GET['user_id'] : 0;
$room_id = isset($_GET['room_id']) ? (int)$_GET['room_id'] : 0;

if ($user_id <= 0) {
    die(json_encode(['status' => 'error', 'message' => 'Invalid user_id']));
}

try {
    $stmt = $conn->prepare("
        SELECT
            u.id            AS user_id,
            u.display_name,
            u.level,
            u.profile_image_url AS image_url,
            u.frame_identifier,
            u.name_color,
            u.font_identifier,
            u.is_verified,
            u.vip_tier,
            u.vip_expires_at,
            COALESCE(rm.role, 'member') AS role
        FROM users u
        LEFT JOIN room_members rm ON u.id = rm.user_id AND rm.room_id = :room_id
        WHERE u.id = :user_id
    ");
    $stmt->execute([':user_id' => $user_id, ':room_id' => $room_id]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user) {
        $user['user_id']     = (int)$user['user_id'];
        $user['level']       = (int)$user['level'];
        $user['is_verified'] = (int)$user['is_verified'];

        // ★ حساب VIP
        $vipTier     = $user['vip_tier'] ?? 'none';
        $vipExpires  = $user['vip_expires_at'];
        $vipIsActive = ($vipTier !== 'none')
            && ($vipExpires === null || strtotime($vipExpires) > time());

        $user['vip_tier']      = $vipIsActive ? $vipTier : 'none';
        $user['vip_is_active'] = $vipIsActive;
        $user['vip_frame_url'] = $vipIsActive
            ? "https://latrotech.online/Copel/vip/frames/frame_{$vipTier}.gif"
            : null;

        unset($user['vip_expires_at']);

        echo json_encode(['status' => 'success', 'user' => $user]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'User not found']);
    }

} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>