<?php
// get_truth_game.php - v5 - مع فحص تلقائي لصلاحية الأسئلة وحذفها

header('Content-Type: application/json; charset=utf-8');
require 'db_connect.php';
require 'fcm_sender.php'; // لإرسال الإشعارات

$couple_id = $_GET['couple_id'] ?? 0;

if (empty($couple_id)) {
    http_response_code(400);
    exit(json_encode(['status' => 'error', 'message' => 'Couple ID is required.']));
}

try {
    $conn->beginTransaction();
    
    $game_info = null;
    $pending_question = null;
    $completed_rounds = [];

    // 1. جلب معلومات اللعبة الأساسية
    $stmt_game = $conn->prepare("SELECT * FROM truth_games WHERE couple_id = :couple_id");
    $stmt_game->execute([':couple_id' => $couple_id]);
    $game_info = $stmt_game->fetch(PDO::FETCH_ASSOC);

    // إذا لم تكن هناك لعبة، قم بإنشاء واحدة
    if (!$game_info) {
        $stmt_couple = $conn->prepare("SELECT user1_id, user2_id FROM couples WHERE id = :couple_id");
        $stmt_couple->execute([':couple_id' => $couple_id]);
        $couple_users = $stmt_couple->fetch(PDO::FETCH_ASSOC);
        
        if ($couple_users && !empty($couple_users['user1_id']) && !empty($couple_users['user2_id'])) {
            $starter_user_id = rand(0, 1) == 0 ? $couple_users['user1_id'] : $couple_users['user2_id'];
            
            $stmt_create = $conn->prepare("INSERT INTO truth_games (couple_id, current_turn_user_id) VALUES (:couple_id, :starter_id)");
            $stmt_create->execute([':couple_id' => $couple_id, ':starter_id' => $starter_user_id]);
            
            $stmt_game->execute([':couple_id' => $couple_id]);
            $game_info = $stmt_game->fetch(PDO::FETCH_ASSOC);
        }
    }

    if ($game_info) {
        // ★★★★★ الحل الجديد: فحص وحذف الأسئلة المنتهية تلقائيًا ★★★★★
        $stmt_expired = $conn->prepare(
            "SELECT * FROM truth_game_rounds 
             WHERE game_id = :game_id 
             AND answer_text IS NULL 
             AND expires_at < NOW()"
        );
        $stmt_expired->execute([':game_id' => $game_info['id']]);
        $expired_rounds = $stmt_expired->fetchAll(PDO::FETCH_ASSOC);
        
        // حذف الأسئلة المنتهية وتحديث الأدوار
        foreach ($expired_rounds as $expired_round) {
            error_log("Auto-deleting expired round ID: " . $expired_round['id']);
            
            // حذف السؤال المنتهي
            $stmt_delete = $conn->prepare("DELETE FROM truth_game_rounds WHERE id = :round_id");
            $stmt_delete->execute([':round_id' => $expired_round['id']]);
            
            // تحديد من كان يجب أن يجيب
            $stmt_couple = $conn->prepare("SELECT user1_id, user2_id FROM couples WHERE id = :couple_id");
            $stmt_couple->execute([':couple_id' => $couple_id]);
            $couple_data = $stmt_couple->fetch(PDO::FETCH_ASSOC);
            
            if ($couple_data) {
                $answer_user_id = ($expired_round['question_user_id'] == $couple_data['user1_id']) 
                    ? $couple_data['user2_id'] 
                    : $couple_data['user1_id'];
                
                // تحديث الدور لمن كان يجب أن يجيب
                $stmt_turn = $conn->prepare("UPDATE truth_games SET current_turn_user_id = :turn_id WHERE id = :game_id");
                $stmt_turn->execute([
                    ':turn_id' => $answer_user_id,
                    ':game_id' => $game_info['id']
                ]);
                
                // إرسال إشعارات للطرفين
                $stmt_names = $conn->prepare("SELECT id, display_name FROM users WHERE id IN (:id1, :id2)");
                $stmt_names->execute([':id1' => $expired_round['question_user_id'], ':id2' => $answer_user_id]);
                $users = $stmt_names->fetchAll(PDO::FETCH_KEY_PAIR);
                
                $skipped_user_name = $users[$answer_user_id] ?? 'شريكك';
                $asker_name = $users[$expired_round['question_user_id']] ?? 'اللاعب';
                
                $message = "انتهى الوقت! لم يقم $skipped_user_name بالإجابة على سؤال $asker_name. الدور الآن على $skipped_user_name لطرح سؤال.";
                
                sendFcmNotification($conn, $couple_data['user1_id'], "انتهى الوقت في لعبة الصراحة", $message, ['type' => 'truth-turn-skipped']);
                sendFcmNotification($conn, $couple_data['user2_id'], "انتهى الوقت في لعبة الصراحة", $message, ['type' => 'truth-turn-skipped']);
                
                // تحديث game_info للحصول على الدور الجديد
                $stmt_game->execute([':couple_id' => $couple_id]);
                $game_info = $stmt_game->fetch(PDO::FETCH_ASSOC);
            }
        }
        
        // 2. جلب السؤال المعلق (إن وجد) - فقط الأسئلة التي لم تنته صلاحيتها
        $stmt_pending = $conn->prepare(
            "SELECT * FROM truth_game_rounds 
             WHERE game_id = :game_id 
             AND answer_text IS NULL 
             AND expires_at > NOW()
             ORDER BY created_at DESC 
             LIMIT 1"
        );
        $stmt_pending->execute([':game_id' => $game_info['id']]);
        $pending_question = $stmt_pending->fetch(PDO::FETCH_ASSOC);

        // 3. جلب الجولات المكتملة - مرتبة من الأقدم للأحدث
        $stmt_completed = $conn->prepare(
            "SELECT * FROM truth_game_rounds 
             WHERE game_id = :game_id 
             AND answer_text IS NOT NULL 
             ORDER BY answered_at ASC"
        );
        $stmt_completed->execute([':game_id' => $game_info['id']]);
        $completed_rounds = $stmt_completed->fetchAll(PDO::FETCH_ASSOC);
    }

    $conn->commit();

    echo json_encode([
        'status' => 'success',
        'data' => [
            'game_info' => $game_info ?: (object)[],
            'pending_question' => $pending_question ?: null,
            'completed_rounds' => $completed_rounds ?: []
        ]
    ]);

} catch (Exception $e) {
    $conn->rollBack();
    http_response_code(500);
    error_log("Get Truth Game Error: " . $e->getMessage());
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>