<?php
header('Content-Type: application/json; charset=utf-8');
require 'db_connect.php';

$roomId        = isset($_GET['room_id'])         ? (int)$_GET['room_id']         : 0;
$userId        = isset($_GET['user_id'])         ? (int)$_GET['user_id']         : 0;
$lastMessageId = isset($_GET['last_message_id']) ? (int)$_GET['last_message_id'] : 0;

if ($roomId <= 0 || $userId <= 0) {
    http_response_code(400);
    die(json_encode(['status' => 'error', 'message' => 'بيانات غير مكتملة']));
}

try {
    // التحقق من أن المستخدم عضو في الغرفة
    $stmt_member = $conn->prepare("SELECT joined_at FROM room_members WHERE room_id = :room_id AND user_id = :user_id");
    $stmt_member->execute([':room_id' => $roomId, ':user_id' => $userId]);
    $member = $stmt_member->fetch(PDO::FETCH_ASSOC);

    if (!$member) {
        http_response_code(403);
        die(json_encode(['status' => 'error', 'message' => 'غير مصرح']));
    }

    $now = time();

    if ($lastMessageId > 0) {
        $stmt = $conn->prepare("
            SELECT
                rm.id, rm.room_id, rm.user_id, rm.message_text, rm.is_system, rm.created_at,
                u.display_name, u.level, u.profile_image_url, u.frame_identifier,
                u.name_color, u.font_identifier, u.is_verified,
                u.vip_tier, u.vip_expires_at, u.vip_gif_url
            FROM room_messages rm
            INNER JOIN room_members rmbr
                ON rmbr.room_id = rm.room_id
               AND rmbr.user_id = :user_id
            LEFT JOIN users u ON rm.user_id = u.id
            WHERE rm.room_id = :room_id
              AND rm.id > :last_id
              AND rm.created_at >= rmbr.joined_at
            ORDER BY rm.created_at ASC
            LIMIT 50
        ");
        $stmt->execute([
            ':room_id' => $roomId,
            ':user_id' => $userId,
            ':last_id' => $lastMessageId,
        ]);
    } else {
        $stmt = $conn->prepare("
            SELECT
                rm.id, rm.room_id, rm.user_id, rm.message_text, rm.is_system, rm.created_at,
                u.display_name, u.level, u.profile_image_url, u.frame_identifier,
                u.name_color, u.font_identifier, u.is_verified,
                u.vip_tier, u.vip_expires_at, u.vip_gif_url
            FROM room_messages rm
            INNER JOIN room_members rmbr
                ON rmbr.room_id = rm.room_id
               AND rmbr.user_id = :user_id
            LEFT JOIN users u ON rm.user_id = u.id
            WHERE rm.room_id = :room_id
              AND rm.created_at >= rmbr.joined_at
            ORDER BY rm.created_at ASC
            LIMIT 50
        ");
        $stmt->execute([
            ':room_id' => $roomId,
            ':user_id' => $userId,
        ]);
    }

    $messages = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $result = [];
    foreach ($messages as $msg) {

        // ★ حساب VIP
        $vipTier     = $msg['vip_tier'] ?? 'none';
        $vipExpires  = $msg['vip_expires_at'];
        $vipIsActive = ($vipTier !== 'none')
            && ($vipExpires === null || strtotime($vipExpires) > $now);

        $vipTierFinal  = $vipIsActive ? $vipTier : 'none';
        $vipGifUrl     = ($vipIsActive && $vipTier === 'gold' && !empty($msg['vip_gif_url']))
                            ? $msg['vip_gif_url']
                            : null;

        $result[] = [
            'id'               => (int)$msg['id'],
            'room_id'          => (int)$msg['room_id'],
            'user_id'          => (int)$msg['user_id'],
            'user_name'        => $msg['display_name'],
            'user_level'       => (int)$msg['level'],
            'user_image_url'   => $msg['profile_image_url'],
            'frame_identifier' => $msg['frame_identifier'],
            'name_color'       => $msg['name_color'],
            'font_identifier'  => $msg['font_identifier'],
            'is_verified'      => (int)$msg['is_verified'],
            'message_text'     => $msg['message_text'],
            'is_system'        => (int)$msg['is_system'],
            'created_at'       => $msg['created_at'],
            // ★ VIP
            'vip_tier'         => $vipTierFinal,
            'vip_is_active'    => $vipIsActive,
            'vip_gif_url'      => $vipGifUrl,
        ];
    }

    echo json_encode(['status' => 'success', 'messages' => $result]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>