<?php
header('Content-Type: application/json; charset=utf-8');
require 'db_connect.php';

$user_id = isset($_GET['user_id']) ? intval($_GET['user_id']) : 0;

if (empty($user_id)) {
    http_response_code(400);
    exit(json_encode([
        'status' => 'error', 
        'message' => 'User ID is required.'
    ]));
}

try {
    // جلب مستوى المستخدم لتحديد الحد الأقصى للزوار
    $userStmt = $conn->prepare("SELECT level FROM users WHERE id = :user_id");
    $userStmt->execute([':user_id' => $user_id]);
    $userLevel = $userStmt->fetchColumn();
    
    if ($userLevel === false) {
        http_response_code(404);
        exit(json_encode([
            'status' => 'error', 
            'message' => 'User not found.'
        ]));
    }
    
    // تحديد عدد الزوار بناءً على المستوى
    if ($userLevel <= 5) {
        $limit = 10;
    } elseif ($userLevel <= 10) {
        $limit = 20;
    } else {
        $limit = 50;
    }
    
    // جلب قائمة الزوار
    $stmt = $conn->prepare(
        "SELECT
            u.id,
            u.display_name,
            u.profile_image_url,
            u.level,
            u.name_color,
            u.font_identifier,
            u.frame_identifier,
            u.is_verified,
            pv.visit_timestamp
        FROM profile_visits pv
        INNER JOIN users u ON pv.visitor_id = u.id
        WHERE pv.visited_id = :user_id
        ORDER BY pv.visit_timestamp DESC
        LIMIT :limit"
    );
    
    $stmt->bindValue(':user_id', $user_id, PDO::PARAM_INT);
    $stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
    $stmt->execute();
    
    $visitors = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // تحويل البيانات للصيغة الصحيحة
    foreach ($visitors as &$visitor) {
        $visitor['is_verified'] = (bool) $visitor['is_verified'];
        $visitor['level'] = (int) $visitor['level'];
        $visitor['id'] = (int) $visitor['id'];
    }
    
    echo json_encode([
        'status' => 'success',
        'data' => $visitors,
        'total' => count($visitors),
        'limit' => $limit,
        'user_level' => (int) $userLevel
    ]);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'status' => 'error', 
        'message' => 'Database error: ' . $e->getMessage()
    ]);
}
?>