<?php
/**
 * get_points_info.php
 * يحصل على معلومات النقاط والمستويات الكاملة للمستخدم
 */

header('Content-Type: application/json; charset=utf-8');
require 'db_connect.php';
require 'PointsSystem.php';

// استقبال البيانات
$data = json_decode(file_get_contents('php://input'), true);
$userId = $data['user_id'] ?? $_POST['user_id'] ?? 0;
$coupleId = $data['couple_id'] ?? $_POST['couple_id'] ?? 0;

if ($userId <= 0) {
    http_response_code(400);
    exit(json_encode(['status' => 'error', 'message' => 'User ID is required']));
}

try {
    $pointsSystem = new PointsSystem($conn);
    $info = $pointsSystem->getUserPointsInfo($userId, $coupleId);
    
    if ($info['success']) {
        echo json_encode([
            'status' => 'success',
            'data' => $info
        ]);
    } else {
        http_response_code(400);
        echo json_encode([
            'status' => 'error',
            'message' => $info['message']
        ]);
    }
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage()
    ]);
}
?>