<?php
// get_messages.php (v4 - Final with Message Status)

header('Content-Type: application/json; charset=utf-8');
require 'db_connect.php';

// تفعيل تسجيل الأخطاء
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', 'php-errors.log');
error_reporting(E_ALL);

$userId = $_GET['user_id'] ?? 0;
$partnerId = $_GET['partner_id'] ?? 0;

if (empty($userId) || empty($partnerId)) {
    http_response_code(400 );
    exit(json_encode(['status' => 'error', 'message' => 'معرفات المستخدمين مطلوبة.']));
}

try {
    // --- التحقق من الحظر ---
    $stmt_check_block = $conn->prepare(
        "SELECT 1 FROM blocked_users 
         WHERE (blocker_id = :user_id AND blocked_id = :partner_id) 
            OR (blocker_id = :partner_id AND blocked_id = :user_id)"
    );
    $stmt_check_block->execute([
        ':user_id' => $userId,
        ':partner_id' => $partnerId
    ]);
    if ($stmt_check_block->fetch()) {
        http_response_code(403 );
        exit(json_encode(['status' => 'error', 'message' => 'لا يمكنك عرض هذه المحادثة لأن أحد الطرفين حظر الآخر.']));
    }

    // ★★★★★   بداية التعديل النهائي هنا   ★★★★★
    // جلب جميع الحقول المطلوبة، بما في ذلك 'status'
    // وتوحيد اسم حقل الوقت إلى 'created_at'
    $stmt = $conn->prepare(
        "SELECT 
            id, 
            sender_id, 
            message_text, 
            status, 
            DATE_FORMAT(timestamp, '%Y-%m-%d %H:%i:%s') as created_at
         FROM messages 
         WHERE (sender_id = :user_id AND recipient_id = :partner_id) 
            OR (sender_id = :partner_id AND recipient_id = :user_id)
         ORDER BY timestamp ASC"
    );
    // ★★★★★    نهاية التعديل النهائي    ★★★★★

    $stmt->execute([
        ':user_id' => $userId,
        ':partner_id' => $partnerId
    ]);
    
    $messages = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'status' => 'success',
        'data' => $messages
    ]);

} catch (Exception $e) {
    http_response_code(500 );
    error_log("Get Messages Error: " . $e->getMessage());
    echo json_encode(['status' => 'error', 'message' => 'حدث خطأ في الخادم أثناء جلب الرسائل.']);
}

$conn = null;
?>
