<?php
// get_memories.php
// v5 - الحل النهائي باستخدام LEFT JOIN
header('Content-Type: application/json; charset=utf-8');
require 'db_connect.php';

$data = json_decode(file_get_contents('php://input'), true);
$user_id = $data['user_id'] ?? 0;

if (empty($user_id)) {
    http_response_code(400 );
    exit(json_encode(['status' => 'error', 'message' => 'User ID is required.']));
}

try {
    // 1. جلب couple_id للمستخدم الحالي
    $stmt_couple = $conn->prepare("SELECT couple_id FROM users WHERE id = :user_id");
    $stmt_couple->execute([':user_id' => $user_id]);
    $user_data = $stmt_couple->fetch(PDO::FETCH_ASSOC);

    if (!$user_data || empty($user_data['couple_id'])) {
        echo json_encode(['status' => 'success', 'data' => ['couple_info' => null, 'memories' => []]]);
        exit();
    }
    $couple_id = $user_data['couple_id'];

    // 2. جلب معلومات الشريكين الكاملة
    $stmt_info = $conn->prepare(
       "SELECT 
            c.start_date, c.first_message_date, c.first_meeting_date, c.first_date_date, c.relationship_start_date,
            u1.id AS user1_id, u1.display_name AS user1_name, u1.profile_image_url AS user1_image, u1.name_color AS user1_name_color, u1.font_identifier AS user1_font_identifier, u1.frame_identifier AS user1_frame_identifier, u1.is_verified AS user1_is_verified,
            u2.id AS user2_id, u2.display_name AS user2_name, u2.profile_image_url AS user2_image, u2.name_color AS user2_name_color, u2.font_identifier AS user2_font_identifier, u2.frame_identifier AS user2_frame_identifier, u2.is_verified AS user2_is_verified
        FROM couples c
        JOIN users u1 ON c.user1_id = u1.id
        JOIN users u2 ON c.user2_id = u2.id
        WHERE c.id = :couple_id"
    );
    $stmt_info->execute([':couple_id' => $couple_id]);
    $couple_info = $stmt_info->fetch(PDO::FETCH_ASSOC);

    if ($couple_info) {
        $couple_info['user1_is_verified'] = (bool)($couple_info['user1_is_verified'] ?? false);
        $couple_info['user2_is_verified'] = (bool)($couple_info['user2_is_verified'] ?? false);
    }

    // ★★★★★   بداية التعديل الرئيسي (استخدام LEFT JOIN)   ★★★★★
    // 3. جلب قائمة الذكريات مع بيانات صاحب الذكرى (إن وجد)
    $stmt_memories = $conn->prepare(
        "SELECT 
            m.id, m.title, m.description, m.emoji, m.memory_date, m.image_url, m.user_id,
            creator.display_name AS creator_name,
            creator.name_color AS creator_name_color,
            creator.font_identifier AS creator_font_identifier,
            creator.is_verified AS creator_is_verified
        FROM memories m
        LEFT JOIN users creator ON m.user_id = creator.id -- تم التغيير إلى LEFT JOIN
        WHERE m.couple_id = :couple_id 
        ORDER BY m.memory_date DESC"
    );
    $stmt_memories->execute([':couple_id' => $couple_id]);
    $memories = $stmt_memories->fetchAll(PDO::FETCH_ASSOC);

    // معالجة النتائج لضمان عدم وجود قيم null تسبب مشاكل في التطبيق
    $memories = array_map(function($memory) {
        $memory['creator_is_verified'] = (bool)($memory['creator_is_verified'] ?? false);
        // يمكنك إضافة قيم افتراضية هنا إذا أردت، مثلاً اسم "مستخدم محذوف"
        $memory['creator_name'] = $memory['creator_name'] ?? ''; 
        return $memory;
    }, $memories);
    // ★★★★★    نهاية التعديل الرئيسي    ★★★★★

    // 4. تجميع البيانات وإرسالها
    echo json_encode([
        'status' => 'success',
        'data' => [
            'couple_info' => $couple_info,
            'memories' => $memories
        ]
    ]);

} catch (Exception $e) {
    http_response_code(500 );
    error_log('Get Memories Error: ' . $e->getMessage());
    echo json_encode(['status' => 'error', 'message' => 'Server error while fetching memories.']);
}
?>
