<?php
// get_leaderboard_individuals.php
header('Content-Type: application/json; charset=utf-8');
require 'db_connect.php';

try {
    $stmt = $conn->prepare(
       "SELECT 
            id,
            display_name,
            profile_image_url,
            level,
            xp,
            name_color,
            font_identifier,
            frame_identifier,
            is_verified
        FROM 
            users
        ORDER BY 
            level DESC, xp DESC
        LIMIT 20"
    );
    
    $stmt->execute();
    $leaderboardData = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    $leaderboard = array_map(function($item) {
        $item['is_verified'] = (bool)$item['is_verified'];
        $item['level'] = (int)$item['level'];
        return $item;
    }, $leaderboardData);
    
    echo json_encode([
        'status' => 'success',
        'data' => $leaderboard
    ]);

} catch (Exception $e) {
    http_response_code(500 );
    echo json_encode(['status' => 'error', 'message' => 'Server error fetching individual leaderboard.']);
}
?>
