<?php
// get_leaderboard_history.php
// يجلب سجل الفائزين السابقين من لوحة الصدارة

header('Content-Type: application/json; charset=utf-8');
require 'db_connect.php';

try {
    $stmt = $conn->prepare(
        "SELECT 
            id, winner_type, `rank`, 
            user1_id, user1_name, user1_image_url,
            user2_id, user2_name, user2_image_url,
            score, win_date
         FROM leaderboard_history
         ORDER BY win_date DESC, winner_type ASC, `rank` ASC"
    );
    $stmt->execute();
    $history_data = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // إعادة هيكلة البيانات لتجميعها حسب تاريخ الفوز
    $grouped_history = [];
    foreach ($history_data as $record) {
        $date = $record['win_date'];
        
        // التأكد من أن الحقول الرقمية هي أرقام
        $record['id'] = (int)$record['id'];
        $record['rank'] = (int)$record['rank'];
        $record['score'] = (int)$record['score'];
        if ($record['user1_id']) $record['user1_id'] = (int)$record['user1_id'];
        if ($record['user2_id']) $record['user2_id'] = (int)$record['user2_id'];

        // إذا لم يكن هذا التاريخ موجودًا في المصفوفة، قم بإنشائه
        if (!isset($grouped_history[$date])) {
            $grouped_history[$date] = [
                'win_date' => $date,
                'individuals' => [],
                'couples' => []
            ];
        }

        // إضافة السجل إلى المجموعة الصحيحة (أفراد أو أزواج)
        if ($record['winner_type'] === 'individual') {
            $grouped_history[$date]['individuals'][] = $record;
        } else {
            $grouped_history[$date]['couples'][] = $record;
        }
    }

    // تحويل المصفوفة الترابطية إلى مصفوفة مفهرسة بسيطة ليقرأها GSON بسهولة
    $final_data = array_values($grouped_history);

    echo json_encode([
        'status' => 'success',
        'data' => $final_data
    ]);

} catch (Exception $e) {
    http_response_code(500 );
    error_log('Get Leaderboard History Error: ' . $e->getMessage());
    echo json_encode(['status' => 'error', 'message' => 'حدث خطأ في الخادم أثناء جلب سجل لوحة الصدارة.']);
}
?>
