<?php
// get_leaderboard_couples.php

header('Content-Type: application/json; charset=utf-8');
require 'db_connect.php';

try {
    // ★★★★★   بداية التعديل: استخدام نفس معادلة حساب نقاط الحب   ★★★★★
    $stmt = $conn->prepare(
       "SELECT 
            c.id AS couple_id,
            (c.love_signals_count * 5 - c.sad_signals_count * 3) AS love_meter,
            u1.id AS user1_id, 
            u1.display_name AS user1_name, 
            u1.profile_image_url AS user1_image_url,
            u1.name_color AS user1_name_color,
            u1.font_identifier AS user1_font_identifier,
            u1.frame_identifier AS user1_frame_identifier,
            u1.is_verified AS user1_is_verified,
            u2.id AS user2_id, 
            u2.display_name AS user2_name, 
            u2.profile_image_url AS user2_image_url,
            u2.name_color AS user2_name_color,
            u2.font_identifier AS user2_font_identifier,
            u2.frame_identifier AS user2_frame_identifier,
            u2.is_verified AS user2_is_verified
        FROM couples c
        JOIN users u1 ON c.user1_id = u1.id
        JOIN users u2 ON c.user2_id = u2.id
        ORDER BY love_meter DESC"
    );
    // ★★★★★    نهاية التعديل    ★★★★★

    $stmt->execute();
    $couples = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // التأكد من أن الحقول الرقمية هي أرقام
    foreach ($couples as &$couple) {
        $couple['love_meter'] = max(0, (int)$couple['love_meter']); // ضمان عدم وجود قيم سالبة
        $couple['user1_id'] = (int)$couple['user1_id'];
        $couple['user2_id'] = (int)$couple['user2_id'];
        $couple['user1_is_verified'] = (bool)$couple['user1_is_verified'];
        $couple['user2_is_verified'] = (bool)$couple['user2_is_verified'];
    }

    echo json_encode([
        'status' => 'success',
        'data' => $couples
    ]);

} catch (Exception $e) {
    http_response_code(500 );
    error_log("Get Couples Leaderboard Error: " . $e->getMessage());
    echo json_encode(['status' => 'error', 'message' => 'Server error: ' . $e->getMessage()]);
}
?>
