<?php
// get_individual_leaderboard.php
header('Content-Type: application/json; charset=utf-8');
require 'db_connect.php';
try {
    $stmt = $conn->prepare(
       "SELECT 
            u.id, u.display_name, u.profile_image_url, u.level, u.xp,
            u.name_color, u.font_identifier, u.frame_identifier, u.is_verified,
            u.vip_tier, u.vip_expires_at
        FROM users u
        ORDER BY u.level DESC, u.xp DESC
        LIMIT 50"
    );
    $stmt->execute();
    $leaderboardData = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    $leaderboard = array_map(function($item) {
        $item['level']       = (int)$item['level'];
        $item['is_verified'] = isset($item['is_verified']) ? (bool)$item['is_verified'] : false;

        // ✅ VIP
        $vipTier   = $item['vip_tier'] ?? 'none';
        $expiresAt = $item['vip_expires_at'] ?? null;
        $item['vip_tier']      = $vipTier;
        $item['vip_is_active'] = (
            $vipTier !== 'none' &&
            $vipTier !== null &&
            ($expiresAt === null || strtotime($expiresAt) > time())
        );
        unset($item['vip_expires_at']);

        return $item;
    }, $leaderboardData);
    
    echo json_encode(['status' => 'success', 'data' => $leaderboard]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Server error fetching individual leaderboard.']);
}
?>