<?php
/**
 * get_daily_limits_stats.php
 * ==========================
 * الحصول على إحصائيات الحدود اليومية للمستخدم
 * 
 * @version 1.0
 * @date 2026-02-05
 */

header('Content-Type: application/json; charset=utf-8');
require 'db_connect.php';

// محاولة تحميل نظام النقاط v2
$useNewRewardSystem = false;
if (file_exists('points_manager_v2.php')) {
    try {
        require 'points_manager_v2.php';
        $useNewRewardSystem = function_exists('getDailyLimitsStats');
    } catch (Exception $e) {
        error_log("Failed to load points_manager_v2.php: " . $e->getMessage());
    }
}

if (!$useNewRewardSystem) {
    http_response_code(501); // Not Implemented
    exit(json_encode([
        'status' => 'error',
        'message' => 'نظام الحدود اليومية غير متاح. يرجى التأكد من وجود points_manager_v2.php'
    ]));
}

// استقبال البيانات
$data = json_decode(file_get_contents('php://input'), true);
$user_id = $data['user_id'] ?? 0;

if ($user_id <= 0) {
    http_response_code(400);
    exit(json_encode([
        'status' => 'error',
        'message' => 'معرف المستخدم مطلوب.'
    ]));
}

try {
    // جلب الإحصائيات
    $result = getDailyLimitsStats($conn, $user_id);
    
    if ($result['status'] === 'success') {
        echo json_encode($result);
    } else {
        throw new Exception($result['message']);
    }

} catch (Exception $e) {
    http_response_code(500);
    error_log("Get Daily Limits Stats Error: " . $e->getMessage());
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage()
    ]);
}
?>
