<?php
// get_couples_leaderboard.php
header('Content-Type: application/json; charset=utf-8');
require 'db_connect.php';
try {
    $stmt = $conn->prepare(
       "SELECT 
            c.id AS couple_id,
            (c.love_signals_count * 5 - c.sad_signals_count * 3) AS love_meter,
            u1.id AS user1_id,
            u1.display_name AS user1_name,
            u1.profile_image_url AS user1_image_url,
            u1.name_color AS user1_name_color,
            u1.font_identifier AS user1_font_identifier,
            u1.frame_identifier AS user1_frame_identifier,
            u1.is_verified AS user1_is_verified,
            u1.vip_tier AS user1_vip_tier,
            u1.vip_expires_at AS user1_vip_expires_at,
            u2.id AS user2_id,
            u2.display_name AS user2_name,
            u2.profile_image_url AS user2_image_url,
            u2.name_color AS user2_name_color,
            u2.font_identifier AS user2_font_identifier,
            u2.frame_identifier AS user2_frame_identifier,
            u2.is_verified AS user2_is_verified,
            u2.vip_tier AS user2_vip_tier,
            u2.vip_expires_at AS user2_vip_expires_at
        FROM couples c
        JOIN users u1 ON c.user1_id = u1.id
        JOIN users u2 ON c.user2_id = u2.id
        ORDER BY love_meter DESC
        LIMIT 20"
    );
    $stmt->execute();
    $leaderboardData = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    $leaderboard = array_map(function($item) {
        $item['love_meter']        = max(0, (int)$item['love_meter']);
        $item['user1_is_verified'] = (bool)$item['user1_is_verified'];
        $item['user2_is_verified'] = (bool)$item['user2_is_verified'];

        // ✅ VIP user1
        $user1VipTier   = $item['user1_vip_tier'] ?? 'none';
        $user1ExpiresAt = $item['user1_vip_expires_at'] ?? null;
        $item['user1_vip_tier']      = $user1VipTier ?? 'none';
        $item['user1_vip_is_active'] = (
            !empty($user1VipTier) &&
            $user1VipTier !== 'none' &&
            ($user1ExpiresAt === null || strtotime($user1ExpiresAt) > time())
        ) ? 1 : 0;
        unset($item['user1_vip_expires_at']);

        // ✅ VIP user2
        $user2VipTier   = $item['user2_vip_tier'] ?? 'none';
        $user2ExpiresAt = $item['user2_vip_expires_at'] ?? null;
        $item['user2_vip_tier']      = $user2VipTier ?? 'none';
        $item['user2_vip_is_active'] = (
            !empty($user2VipTier) &&
            $user2VipTier !== 'none' &&
            ($user2ExpiresAt === null || strtotime($user2ExpiresAt) > time())
        ) ? 1 : 0;
        unset($item['user2_vip_expires_at']);

        return $item;
    }, $leaderboardData);
    
    echo json_encode(['status' => 'success', 'data' => $leaderboard]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Server error fetching couples leaderboard.']);
}
?>